/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.types.expressions.LocalClassifierAnalyzer;
import org.jetbrains.kotlin.types.expressions.MultiDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;

public class InjectorForMacros {
    private final Project project;
    private final ModuleDescriptor moduleDescriptor;
    private final KotlinBuiltIns kotlinBuiltIns;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    private final ExpressionTypingServices expressionTypingServices;
    private final ExpressionTypingComponents expressionTypingComponents;
    private final CallResolver callResolver;
    private final TypeResolver typeResolver;
    private final GlobalContext globalContext;
    private final StorageManager storageManager;
    private final AdditionalCheckerProvider.DefaultProvider defaultProvider;
    private final SymbolUsageValidator symbolUsageValidator;
    private final StatementFilter statementFilter;
    private final AnnotationResolver annotationResolver;
    private final CallExpressionResolver callExpressionResolver;
    private final ControlStructureTypingUtils controlStructureTypingUtils;
    private final DescriptorResolver descriptorResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    private final FakeCallResolver fakeCallResolver;
    private final FunctionDescriptorResolver functionDescriptorResolver;
    private final LocalClassifierAnalyzer localClassifierAnalyzer;
    private final MultiDeclarationResolver multiDeclarationResolver;
    private final ReflectionTypes reflectionTypes;
    private final ValueParameterResolver valueParameterResolver;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CallCompleter callCompleter;
    private final CandidateResolver candidateResolver;
    private final TaskPrioritizer taskPrioritizer;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final TypeResolver.FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final TypeLazinessToken typeLazinessToken;

    public InjectorForMacros(@NotNull Project project, @NotNull ModuleDescriptor moduleDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/di/InjectorForMacros", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/di/InjectorForMacros", "<init>"));
        }
        this.project = project;
        this.moduleDescriptor = moduleDescriptor;
        this.kotlinBuiltIns = moduleDescriptor.getBuiltIns();
        this.platformToKotlinClassMap = moduleDescriptor.getPlatformToKotlinClassMap();
        this.expressionTypingComponents = new ExpressionTypingComponents();
        this.expressionTypingServices = new ExpressionTypingServices(this.getExpressionTypingComponents());
        this.callResolver = new CallResolver();
        this.annotationResolver = new AnnotationResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.flexibleTypeCapabilitiesProvider = new TypeResolver.FlexibleTypeCapabilitiesProvider();
        this.globalContext = ContextPackage.GlobalContext();
        this.storageManager = this.globalContext.getStorageManager();
        this.typeLazinessToken = new TypeLazinessToken();
        this.dynamicTypesSettings = new DynamicTypesSettings();
        this.typeResolver = new TypeResolver(this.annotationResolver, this.qualifiedExpressionResolver, moduleDescriptor, this.flexibleTypeCapabilitiesProvider, this.storageManager, this.typeLazinessToken, this.dynamicTypesSettings);
        this.defaultProvider = AdditionalCheckerProvider.DefaultProvider.INSTANCE$;
        this.symbolUsageValidator = this.defaultProvider.getSymbolUsageValidator();
        this.statementFilter = new StatementFilter();
        this.callExpressionResolver = new CallExpressionResolver(this.getCallResolver(), this.kotlinBuiltIns);
        this.controlStructureTypingUtils = new ControlStructureTypingUtils(this.getCallResolver());
        this.descriptorResolver = new DescriptorResolver();
        this.delegatedPropertyResolver = new DelegatedPropertyResolver();
        this.forLoopConventionsChecker = new ForLoopConventionsChecker();
        this.fakeCallResolver = new FakeCallResolver(project, this.getCallResolver());
        this.functionDescriptorResolver = new FunctionDescriptorResolver(this.getTypeResolver(), this.descriptorResolver, this.annotationResolver, this.storageManager, this.getExpressionTypingServices(), this.kotlinBuiltIns);
        this.localClassifierAnalyzer = new LocalClassifierAnalyzer(this.descriptorResolver, this.functionDescriptorResolver, this.getTypeResolver(), this.annotationResolver);
        this.multiDeclarationResolver = new MultiDeclarationResolver(this.fakeCallResolver, this.descriptorResolver, this.getTypeResolver(), this.symbolUsageValidator);
        this.reflectionTypes = new ReflectionTypes(moduleDescriptor);
        this.valueParameterResolver = new ValueParameterResolver(this.defaultProvider, this.getExpressionTypingServices());
        this.argumentTypeResolver = new ArgumentTypeResolver();
        this.candidateResolver = new CandidateResolver();
        this.callCompleter = new CallCompleter(this.argumentTypeResolver, this.candidateResolver);
        this.taskPrioritizer = new TaskPrioritizer(this.storageManager);
        this.expressionTypingServices.setStatementFilter(this.statementFilter);
        this.expressionTypingComponents.setAdditionalCheckerProvider(this.defaultProvider);
        this.expressionTypingComponents.setAnnotationResolver(this.annotationResolver);
        this.expressionTypingComponents.setBuiltIns(this.kotlinBuiltIns);
        this.expressionTypingComponents.setCallExpressionResolver(this.callExpressionResolver);
        this.expressionTypingComponents.setCallResolver(this.callResolver);
        this.expressionTypingComponents.setControlStructureTypingUtils(this.controlStructureTypingUtils);
        this.expressionTypingComponents.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingComponents.setDynamicTypesSettings(this.dynamicTypesSettings);
        this.expressionTypingComponents.setExpressionTypingServices(this.expressionTypingServices);
        this.expressionTypingComponents.setForLoopConventionsChecker(this.forLoopConventionsChecker);
        this.expressionTypingComponents.setFunctionDescriptorResolver(this.functionDescriptorResolver);
        this.expressionTypingComponents.setGlobalContext(this.globalContext);
        this.expressionTypingComponents.setLocalClassifierAnalyzer(this.localClassifierAnalyzer);
        this.expressionTypingComponents.setMultiDeclarationResolver(this.multiDeclarationResolver);
        this.expressionTypingComponents.setPlatformToKotlinClassMap(this.platformToKotlinClassMap);
        this.expressionTypingComponents.setReflectionTypes(this.reflectionTypes);
        this.expressionTypingComponents.setSymbolUsageValidator(this.symbolUsageValidator);
        this.expressionTypingComponents.setTypeResolver(this.typeResolver);
        this.expressionTypingComponents.setValueParameterResolver(this.valueParameterResolver);
        this.callResolver.setAdditionalCheckerProvider(this.defaultProvider);
        this.callResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.callResolver.setCallCompleter(this.callCompleter);
        this.callResolver.setCandidateResolver(this.candidateResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setTaskPrioritizer(this.taskPrioritizer);
        this.callResolver.setTypeResolver(this.typeResolver);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setStorageManager(this.storageManager);
        this.annotationResolver.setTypeResolver(this.typeResolver);
        this.callExpressionResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setBuiltIns(this.kotlinBuiltIns);
        this.descriptorResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setStorageManager(this.storageManager);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.delegatedPropertyResolver.setAdditionalCheckerProvider(this.defaultProvider);
        this.delegatedPropertyResolver.setBuiltIns(this.kotlinBuiltIns);
        this.delegatedPropertyResolver.setCallResolver(this.callResolver);
        this.delegatedPropertyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.forLoopConventionsChecker.setBuiltIns(this.kotlinBuiltIns);
        this.forLoopConventionsChecker.setFakeCallResolver(this.fakeCallResolver);
        this.forLoopConventionsChecker.setSymbolUsageValidator(this.symbolUsageValidator);
        this.argumentTypeResolver.setBuiltIns(this.kotlinBuiltIns);
        this.argumentTypeResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.argumentTypeResolver.setTypeResolver(this.typeResolver);
        this.candidateResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.qualifiedExpressionResolver.setSymbolUsageValidator(this.symbolUsageValidator);
    }

    @PreDestroy
    public void destroy() {
    }

    public ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    public ExpressionTypingComponents getExpressionTypingComponents() {
        return this.expressionTypingComponents;
    }

    public CallResolver getCallResolver() {
        return this.callResolver;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }
}

