/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<? super String, ? extends InputStream> loadResource;

    static {
        $kotlinClass = Reflection.createKotlinClass(ResourceLoadingClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassData findClassData(@JetValueParameter(name="classId") @NotNull ClassId classId) {
        DeserializedPackageFragment deserializedPackageFragment;
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        PackageFragmentDescriptor packageFragmentDescriptor = KotlinPackage.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (packageFragmentDescriptor == null) {
            return null;
        }
        PackageFragmentDescriptor packageFragment = packageFragmentDescriptor;
        InputStream inputStream = this.loadResource.invoke(this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream2 = inputStream;
        ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(stream2, this.serializedResourcePaths.getEXTENSION_REGISTRY());
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragment;
        if (!(packageFragmentDescriptor2 instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor2 = null;
        }
        if ((deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor2) == null) {
            deserializedPackageFragment = (DeserializedPackageFragment)((Object)KotlinPackage.error("Not a deserialized package fragment: " + packageFragment));
        }
        NameResolver nameResolver = deserializedPackageFragment.getNameResolver();
        Name expectedShortName = classId.getShortClassName();
        Name actualShortName = nameResolver.getClassId(classProto.getFqName()).getShortClassName();
        if (!actualShortName.isSpecial() && Intrinsics.areEqual(actualShortName, expectedShortName) ^ true) {
            return null;
        }
        return new ClassData(nameResolver, classProto);
    }

    public ResourceLoadingClassDataFinder(@JetValueParameter(name="packageFragmentProvider") @NotNull PackageFragmentProvider packageFragmentProvider, @JetValueParameter(name="serializedResourcePaths") @NotNull SerializedResourcePaths serializedResourcePaths, @JetValueParameter(name="loadResource") @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(serializedResourcePaths, "serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, "loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

