/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.ArrayList;
import java.util.List;
import kotlin.reflect.jvm.internal.impl.name.FqNameBase;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;

public final class FqName
extends FqNameBase {
    public static final FqName ROOT = new FqName("");
    @NotNull
    private final FqNameUnsafe fqName;
    private transient FqName parent;

    @NotNull
    public static FqName fromSegments(@NotNull List<String> names2) {
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "kotlin/reflect/jvm/internal/impl/name/FqName", "fromSegments"));
        }
        FqName fqName2 = new FqName(UtilsPackage.join(names2, "."));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "fromSegments"));
        }
        return fqName2;
    }

    public FqName(@NotNull String fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqName", "<init>"));
        }
        this.fqName = new FqNameUnsafe(fqName2, this);
        this.validateFqName();
    }

    public FqName(@NotNull FqNameUnsafe fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqName", "<init>"));
        }
        this.fqName = fqName2;
        this.validateFqName();
    }

    private FqName(@NotNull FqNameUnsafe fqName2, FqName parent) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqName", "<init>"));
        }
        this.fqName = fqName2;
        this.parent = parent;
        this.validateFqName();
    }

    private void validateFqName() {
        if (!FqName.isValidAfterUnsafeCheck(this.fqName.asString())) {
            throw new IllegalArgumentException("incorrect fq name: " + this.fqName);
        }
    }

    static boolean isValidAfterUnsafeCheck(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "kotlin/reflect/jvm/internal/impl/name/FqName", "isValidAfterUnsafeCheck"));
        }
        return qualifiedName.indexOf(60) < 0;
    }

    @Override
    @NotNull
    public String asString() {
        String string = this.fqName.asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "asString"));
        }
        return string;
    }

    @NotNull
    public FqNameUnsafe toUnsafe() {
        FqNameUnsafe fqNameUnsafe = this.fqName;
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "toUnsafe"));
        }
        return fqNameUnsafe;
    }

    public boolean isRoot() {
        return this.fqName.isRoot();
    }

    @NotNull
    public FqName parent() {
        if (this.parent != null) {
            FqName fqName2 = this.parent;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "parent"));
            }
            return fqName2;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        FqName fqName3 = this.parent = new FqName(this.fqName.parent());
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "parent"));
        }
        return fqName3;
    }

    @NotNull
    public FqName child(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/name/FqName", "child"));
        }
        FqName fqName2 = new FqName(this.fqName.child(name), this);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "child"));
        }
        return fqName2;
    }

    @NotNull
    public Name shortName() {
        Name name = this.fqName.shortName();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "shortName"));
        }
        return name;
    }

    @Override
    @NotNull
    public Name shortNameOrSpecial() {
        Name name = this.fqName.shortNameOrSpecial();
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "shortNameOrSpecial"));
        }
        return name;
    }

    @NotNull
    public List<FqName> path() {
        final ArrayList<FqName> path = new ArrayList<FqName>();
        path.add(ROOT);
        this.fqName.walk(new FqNameUnsafe.WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName2) {
                if (shortName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "kotlin/reflect/jvm/internal/impl/name/FqName$1", "segment"));
                }
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "kotlin/reflect/jvm/internal/impl/name/FqName$1", "segment"));
                }
                path.add(new FqName(fqName2));
            }
        });
        ArrayList<FqName> arrayList = path;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "path"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Name> pathSegments() {
        List<Name> list = this.fqName.pathSegments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "pathSegments"));
        }
        return list;
    }

    public boolean firstSegmentIs(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "kotlin/reflect/jvm/internal/impl/name/FqName", "firstSegmentIs"));
        }
        return this.fqName.firstSegmentIs(segment);
    }

    public boolean lastSegmentIs(@NotNull Name segment) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "kotlin/reflect/jvm/internal/impl/name/FqName", "lastSegmentIs"));
        }
        return this.fqName.lastSegmentIs(segment);
    }

    public boolean isAncestorOf(@NotNull FqName other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "kotlin/reflect/jvm/internal/impl/name/FqName", "isAncestorOf"));
        }
        String thisString = this.asString();
        String otherString = other.asString();
        return otherString.equals(thisString) || otherString.startsWith(thisString + ".");
    }

    @NotNull
    public static FqName topLevel(@NotNull Name shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "kotlin/reflect/jvm/internal/impl/name/FqName", "topLevel"));
        }
        FqName fqName2 = new FqName(FqNameUnsafe.topLevel(shortName));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/name/FqName", "topLevel"));
        }
        return fqName2;
    }

    public String toString() {
        return this.fqName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqName)) {
            return false;
        }
        FqName otherFqName = (FqName)o;
        return this.fqName.equals(otherFqName.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }
}

