/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import java.awt.HeadlessException;
import java.awt.Toolkit;

public class JBUI {
    private static boolean IS_HIDPI = JBUI.calculateHiDPI();

    private static boolean calculateHiDPI() {
        if (SystemInfo.isMac) {
            return false;
        }
        if (SystemProperties.is("hidpi")) {
            return true;
        }
        if (SystemProperties.has("hidpi") && !SystemProperties.is("hidpi")) {
            return false;
        }
        return SystemInfo.isWindows && JBUI.getSystemDPI() > 144;
    }

    private static int getSystemDPI() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            return 96;
        }
    }

    public static int scale(int i) {
        return JBUI.isHiDPI() ? 2 * i : i;
    }

    public static float scale(float f) {
        return f * (float)JBUI.scale(1);
    }

    public static boolean isHiDPI() {
        return IS_HIDPI;
    }
}

