/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import sun.misc.Resource;

class MemoryResource
extends Resource {
    private String myName;
    private URL myUrl;
    private final byte[] myContent;

    public MemoryResource(String name, URL url, byte[] content) {
        this.myName = name;
        this.myUrl = url;
        this.myContent = content;
    }

    public String getName() {
        return this.myName;
    }

    public URL getURL() {
        return this.myUrl;
    }

    public URL getCodeSourceURL() {
        return this.myUrl;
    }

    public InputStream getInputStream() throws IOException {
        return new UnsyncByteArrayInputStream(this.myContent);
    }

    public int getContentLength() throws IOException {
        return this.myContent.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static MemoryResource load(URL baseUrl, @NotNull ZipFile zipFile, @NotNull ZipEntry entry) throws IOException {
        if (zipFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zipFile", "com/intellij/util/lang/MemoryResource", "load"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/util/lang/MemoryResource", "load"));
        }
        String name = entry.getName();
        URL url = new URL(baseUrl, name);
        byte[] content = ArrayUtil.EMPTY_BYTE_ARRAY;
        InputStream stream2 = zipFile.getInputStream(entry);
        if (stream2 != null) {
            try {
                content = FileUtil.loadBytes(stream2, (int)entry.getSize());
            }
            finally {
                stream2.close();
            }
        }
        MemoryResource memoryResource = new MemoryResource(name, url, content);
        if (memoryResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/MemoryResource", "load"));
        }
        return memoryResource;
    }
}

