/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.lexer;

import com.intellij.lang.java.lexer._JavaLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaLexer
extends LexerBase {
    private static final HashTable[] TABLES = new HashTable[]{new HashTable(LanguageLevel.JDK_1_5), new HashTable(LanguageLevel.JDK_1_4), new HashTable(LanguageLevel.JDK_1_3)};
    private final _JavaLexer myFlexLexer;
    private final HashTable myTable;
    private CharSequence myBuffer;
    private char[] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private IElementType myTokenType;

    private static HashTable getTable(LanguageLevel level) {
        for (HashTable table : TABLES) {
            if (!level.isAtLeast(table.myLevel)) continue;
            return table;
        }
        throw new IllegalArgumentException("Unsupported level: " + (Object)((Object)level));
    }

    public static boolean isKeyword(String id, LanguageLevel level) {
        return JavaLexer.getTable(level).contains(id);
    }

    public JavaLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/lang/java/lexer/JavaLexer", "<init>"));
        }
        this.myFlexLexer = new _JavaLexer(level);
        this.myTable = JavaLexer.getTable(level);
    }

    @Override
    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lang/java/lexer/JavaLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public final IElementType getTokenType() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        return this.myTokenType;
    }

    @Override
    public final int getTokenStart() {
        return this.myBufferIndex;
    }

    @Override
    public final int getTokenEnd() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        return this.myTokenEndOffset;
    }

    @Override
    public final void advance() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        this.myTokenType = null;
    }

    private void _locateToken() {
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myTokenType = null;
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex] : this.myBuffer.charAt(this.myBufferIndex);
        switch (c) {
            default: {
                this.flexLocateToken();
                break;
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + 1);
                break;
            }
            case '/': {
                char nextChar;
                if (this.myBufferIndex + 1 >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                char c2 = nextChar = this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 1] : this.myBuffer.charAt(this.myBufferIndex + 1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + 2);
                    break;
                }
                if (nextChar == '*') {
                    if (this.myBufferIndex + 2 >= this.myBufferEndOffset || (this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 2] : this.myBuffer.charAt(this.myBufferIndex + 2)) != '*' || this.myBufferIndex + 3 < this.myBufferEndOffset && (this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 3] : this.myBuffer.charAt(this.myBufferIndex + 3)) == '/') {
                        this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 2);
                        break;
                    }
                    this.myTokenType = JavaDocElementType.DOC_COMMENT;
                    this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 3);
                    break;
                }
                if (c > '\u007f' && Character.isJavaIdentifierStart(c)) {
                    this.myTokenEndOffset = this.getIdentifier(this.myBufferIndex + 1);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\"': 
            case '\'': {
                this.myTokenType = c == '\"' ? JavaTokenType.STRING_LITERAL : JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEndOffset = this.getClosingParenthesis(this.myBufferIndex + 1, c);
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int offset) {
        char c;
        if (offset >= this.myBufferEndOffset) {
            return this.myBufferEndOffset;
        }
        int pos = offset;
        char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') {
            if (++pos == this.myBufferEndOffset) {
                return pos;
            }
            c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexLexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexLexer.advance();
            this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getClosingParenthesis(int offset, char c) {
        int pos;
        block6: {
            char cur;
            if (offset >= this.myBufferEndOffset) {
                return this.myBufferEndOffset;
            }
            pos = offset;
            char c2 = cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            while (true) {
                if (cur != c && cur != '\n' && cur != '\r' && cur != '\\') {
                    if (++pos >= this.myBufferEndOffset) {
                        return this.myBufferEndOffset;
                    }
                    cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
                    continue;
                }
                if (cur != '\\') break;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
                if (cur == '\n' || cur == '\r') continue;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            }
            if (cur == c) break block6;
            --pos;
        }
        return pos + 1;
    }

    private int getClosingComment(int offset) {
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset - 1; ++pos) {
            char c;
            char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            if (c == '*' && (this.myBufferArray != null ? this.myBufferArray[pos + 1] : this.myBuffer.charAt(pos + 1)) == '/') break;
        }
        return pos + 2;
    }

    private int getLineTerminator(int offset) {
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset; ++pos) {
            char c;
            char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            if (c == '\r' || c == '\n') break;
        }
        return pos;
    }

    private int getIdentifier(int offset) {
        CharSequence lBuffer = this.myBuffer;
        char[] lBufferArray = this.myBufferArray;
        int hashCode = (lBufferArray != null ? lBufferArray[offset - 1] : lBuffer.charAt(offset - 1)) * 2;
        int pos = offset;
        int lBufferEnd = this.myBufferEndOffset;
        if (pos < lBufferEnd) {
            char c;
            char c2 = c = lBufferArray != null ? lBufferArray[pos] : lBuffer.charAt(pos);
            while (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$' || c > '\u007f' && Character.isJavaIdentifierPart(c)) {
                hashCode += c;
                if (++pos == lBufferEnd) break;
                c = lBufferArray != null ? lBufferArray[pos] : lBuffer.charAt(pos);
            }
        }
        this.myTokenType = this.myTable.contains(hashCode, lBufferArray, lBuffer, offset - 1) ? this.myTable.getTokenType(hashCode) : JavaTokenType.IDENTIFIER;
        return pos;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/lexer/JavaLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    @Override
    public final int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    private static final class HashTable {
        private static final Logger LOG = Logger.getInstance("com.intellij.Lexer.JavaLexer");
        private final LanguageLevel myLevel;
        private final char[][] myTable = new char[999][];
        private final IElementType[] myKeywords = new IElementType[999];
        private final Set<String> myKeywordsInSet = new THashSet<String>();

        private void add(String s, IElementType tokenType) {
            char[] chars = s.toCharArray();
            int hashCode = chars[0] * 2;
            for (int j = 1; j < chars.length; ++j) {
                hashCode += chars[j];
            }
            int modHashCode = hashCode % 999;
            LOG.assertTrue(this.myTable[modHashCode] == null);
            this.myTable[modHashCode] = chars;
            this.myKeywords[modHashCode] = tokenType;
            this.myKeywordsInSet.add(s);
        }

        public boolean contains(String s) {
            return this.myKeywordsInSet.contains(s);
        }

        private boolean contains(int hashCode, char[] bufferArray, CharSequence buffer, int offset) {
            int modHashCode = hashCode % 999;
            char[] kwd = this.myTable[modHashCode];
            if (kwd == null) {
                return false;
            }
            if (bufferArray != null) {
                for (int j = 0; j < kwd.length; ++j) {
                    if (bufferArray[j + offset] == kwd[j]) continue;
                    return false;
                }
            } else {
                for (int j = 0; j < kwd.length; ++j) {
                    if (buffer.charAt(j + offset) == kwd[j]) continue;
                    return false;
                }
            }
            return true;
        }

        private IElementType getTokenType(int hashCode) {
            return this.myKeywords[hashCode % 999];
        }

        private HashTable(LanguageLevel level) {
            this.myLevel = level;
            if (level.isAtLeast(LanguageLevel.JDK_1_4)) {
                this.add("assert", JavaTokenType.ASSERT_KEYWORD);
                if (level.isAtLeast(LanguageLevel.JDK_1_5)) {
                    this.add("enum", JavaTokenType.ENUM_KEYWORD);
                }
            }
            this.add("abstract", JavaTokenType.ABSTRACT_KEYWORD);
            this.add("default", JavaTokenType.DEFAULT_KEYWORD);
            this.add("if", JavaTokenType.IF_KEYWORD);
            this.add("private", JavaTokenType.PRIVATE_KEYWORD);
            this.add("this", JavaTokenType.THIS_KEYWORD);
            this.add("boolean", JavaTokenType.BOOLEAN_KEYWORD);
            this.add("do", JavaTokenType.DO_KEYWORD);
            this.add("implements", JavaTokenType.IMPLEMENTS_KEYWORD);
            this.add("protected", JavaTokenType.PROTECTED_KEYWORD);
            this.add("throw", JavaTokenType.THROW_KEYWORD);
            this.add("break", JavaTokenType.BREAK_KEYWORD);
            this.add("double", JavaTokenType.DOUBLE_KEYWORD);
            this.add("import", JavaTokenType.IMPORT_KEYWORD);
            this.add("public", JavaTokenType.PUBLIC_KEYWORD);
            this.add("throws", JavaTokenType.THROWS_KEYWORD);
            this.add("byte", JavaTokenType.BYTE_KEYWORD);
            this.add("else", JavaTokenType.ELSE_KEYWORD);
            this.add("instanceof", JavaTokenType.INSTANCEOF_KEYWORD);
            this.add("return", JavaTokenType.RETURN_KEYWORD);
            this.add("transient", JavaTokenType.TRANSIENT_KEYWORD);
            this.add("case", JavaTokenType.CASE_KEYWORD);
            this.add("extends", JavaTokenType.EXTENDS_KEYWORD);
            this.add("int", JavaTokenType.INT_KEYWORD);
            this.add("short", JavaTokenType.SHORT_KEYWORD);
            this.add("try", JavaTokenType.TRY_KEYWORD);
            this.add("catch", JavaTokenType.CATCH_KEYWORD);
            this.add("final", JavaTokenType.FINAL_KEYWORD);
            this.add("interface", JavaTokenType.INTERFACE_KEYWORD);
            this.add("static", JavaTokenType.STATIC_KEYWORD);
            this.add("void", JavaTokenType.VOID_KEYWORD);
            this.add("char", JavaTokenType.CHAR_KEYWORD);
            this.add("finally", JavaTokenType.FINALLY_KEYWORD);
            this.add("long", JavaTokenType.LONG_KEYWORD);
            this.add("strictfp", JavaTokenType.STRICTFP_KEYWORD);
            this.add("volatile", JavaTokenType.VOLATILE_KEYWORD);
            this.add("class", JavaTokenType.CLASS_KEYWORD);
            this.add("float", JavaTokenType.FLOAT_KEYWORD);
            this.add("native", JavaTokenType.NATIVE_KEYWORD);
            this.add("super", JavaTokenType.SUPER_KEYWORD);
            this.add("while", JavaTokenType.WHILE_KEYWORD);
            this.add("const", JavaTokenType.CONST_KEYWORD);
            this.add("for", JavaTokenType.FOR_KEYWORD);
            this.add("new", JavaTokenType.NEW_KEYWORD);
            this.add("switch", JavaTokenType.SWITCH_KEYWORD);
            this.add("continue", JavaTokenType.CONTINUE_KEYWORD);
            this.add("goto", JavaTokenType.GOTO_KEYWORD);
            this.add("package", JavaTokenType.PACKAGE_KEYWORD);
            this.add("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
            this.add("true", JavaTokenType.TRUE_KEYWORD);
            this.add("false", JavaTokenType.FALSE_KEYWORD);
            this.add("null", JavaTokenType.NULL_KEYWORD);
        }
    }
}

