/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.Stream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=22, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class UtilsPackage$collections$4f225188 {
    @NotNull
    public static final <K, V> Map<K, V> valuesToMap(@JetValueParameter(name="$receiver") Stream<? extends V> $receiver, @JetValueParameter(name="key") @NotNull Function1<? super V, ? extends K> key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(key, "key");
        LinkedHashMap map = new LinkedHashMap();
        Iterator<V> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            V v = iterator2.next();
            KotlinPackage.set(map, key.invoke(v), v);
        }
        return map;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@JetValueParameter(name="$receiver") Stream<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value, "value");
        LinkedHashMap map = new LinkedHashMap();
        Iterator<K> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            K k = iterator2.next();
            KotlinPackage.set(map, k, value.invoke(k));
        }
        return map;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@JetValueParameter(name="$receiver") Stream<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value, "value");
        LinkedHashMap map = new LinkedHashMap();
        Iterator<K> iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            K k = iterator2.next();
            V v = value.invoke(k);
            if (!(v != null)) continue;
            KotlinPackage.set(map, k, v);
        }
        return map;
    }

    @NotNull
    public static final <K, V> Map<K, V> valuesToMap(@JetValueParameter(name="$receiver") Iterable<? extends V> $receiver, @JetValueParameter(name="key") @NotNull Function1<? super V, ? extends K> key) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(key, "key");
        LinkedHashMap map = new LinkedHashMap();
        for (V v : $receiver) {
            KotlinPackage.set(map, key.invoke(v), v);
        }
        return map;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@JetValueParameter(name="$receiver") Iterable<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value, "value");
        LinkedHashMap map = new LinkedHashMap();
        for (K k : $receiver) {
            KotlinPackage.set(map, k, value.invoke(k));
        }
        return map;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@JetValueParameter(name="$receiver") Iterable<? extends K> $receiver, @JetValueParameter(name="value") @NotNull Function1<? super K, ? extends V> value) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value, "value");
        LinkedHashMap map = new LinkedHashMap();
        for (K k : $receiver) {
            V v = value.invoke(k);
            if (!(v != null)) continue;
            KotlinPackage.set(map, k, v);
        }
        return map;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@JetValueParameter(name="$receiver") Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        LinkedHashMap map = new LinkedHashMap();
        for (IndexedValue<K> indexedValue : KotlinPackage.withIndex($receiver)) {
            int index2 = indexedValue.component1();
            K k = indexedValue.component2();
            KotlinPackage.set(map, k, index2);
        }
        return map;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(@JetValueParameter(name="$receiver") C $receiver, @JetValueParameter(name="body") @NotNull Function0<? extends C> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(body, "body");
        return (C)($receiver.isEmpty() ? (Collection)body.invoke() : $receiver);
    }

    @NotNull
    public static final <T> List<T> emptyOrSingletonList(@JetValueParameter(name="item", type="?") @Nullable T item) {
        return item == null ? KotlinPackage.listOf() : KotlinPackage.listOf(item);
    }

    public static final <T> void addIfNotNull(@JetValueParameter(name="$receiver") Collection<T> $receiver, @JetValueParameter(name="t", type="?") @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(@JetValueParameter(name="expectedSize") int expectedSize) {
        return new HashMap(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(@JetValueParameter(name="expectedSize") int expectedSize) {
        return new HashSet(expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1);
    }

    @NotNull
    public static final <T> List<T> toReadOnlyList(@JetValueParameter(name="$receiver") Collection<? extends T> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isEmpty()) {
            List list2 = Collections.emptyList();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull(list2, "Collections.emptyList()");
        } else {
            list = new ArrayList<T>($receiver);
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(@JetValueParameter(name="$receiver", type="?") T $receiver) {
        return $receiver != null ? Collections.singletonList($receiver) : Collections.emptyList();
    }
}

