/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

public class JetTypeChecker {
    public static final JetTypeChecker DEFAULT = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl()));
    public static final JetTypeChecker FLEXIBLE_UNEQUAL_TO_INFLEXIBLE = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl()){

        @Override
        protected boolean heterogeneousEquivalence(JetType inflexibleType, JetType flexibleType) {
            return false;
        }
    });
    private final TypeCheckingProcedure procedure;

    @NotNull
    public static JetTypeChecker withAxioms(final @NotNull TypeConstructorEquality equalityAxioms) {
        if (equalityAxioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalityAxioms", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "withAxioms"));
        }
        JetTypeChecker jetTypeChecker = new JetTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl(){

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor constructor1, @NotNull TypeConstructor constructor2) {
                if (constructor1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor1", "org/jetbrains/kotlin/types/checker/JetTypeChecker$2", "assertEqualTypeConstructors"));
                }
                if (constructor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor2", "org/jetbrains/kotlin/types/checker/JetTypeChecker$2", "assertEqualTypeConstructors"));
                }
                return constructor1.equals(constructor2) || equalityAxioms.equals(constructor1, constructor2);
            }
        }));
        if (jetTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "withAxioms"));
        }
        return jetTypeChecker;
    }

    private JetTypeChecker(@NotNull TypeCheckingProcedure procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "<init>"));
        }
        this.procedure = procedure;
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "isSubtypeOf"));
        }
        return this.procedure.isSubtypeOf(subtype, supertype);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/types/checker/JetTypeChecker", "equalTypes"));
        }
        return this.procedure.equalTypes(a, b);
    }

    public static interface TypeConstructorEquality {
        public boolean equals(@NotNull TypeConstructor var1, @NotNull TypeConstructor var2);
    }
}

