/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;

public abstract class TypeConstructorImpl
extends AnnotatedImpl
implements TypeConstructor {
    private final List<TypeParameterDescriptor> parameters;
    private final Collection<JetType> supertypes;
    private final String debugName;
    private final boolean isFinal;
    private final ClassifierDescriptor classifierDescriptor;

    @NotNull
    public static TypeConstructorImpl createForClass(@NotNull ClassDescriptor classDescriptor, @NotNull Annotations annotations2, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull Collection<JetType> supertypes2) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl((ClassifierDescriptor)classDescriptor, annotations2, isFinal, debugName, (List)parameters2, (Collection)supertypes2){

            @Override
            public int hashCode() {
                return AbstractClassTypeConstructor.hashCode(this);
            }

            @Override
            public boolean equals(Object obj) {
                return AbstractClassTypeConstructor.equals(this, obj);
            }
        };
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForClass"));
        }
        return typeConstructorImpl;
    }

    @NotNull
    public static TypeConstructorImpl createForTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Annotations annotations2, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull Collection<JetType> supertypes2) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        TypeConstructorImpl typeConstructorImpl = new TypeConstructorImpl((ClassifierDescriptor)typeParameterDescriptor, annotations2, isFinal, debugName, (List)parameters2, (Collection)supertypes2){

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        if (typeConstructorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "createForTypeParameter"));
        }
        return typeConstructorImpl;
    }

    private TypeConstructorImpl(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull Annotations annotations2, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull Collection<JetType> supertypes2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/types/TypeConstructorImpl", "<init>"));
        }
        super(annotations2);
        this.classifierDescriptor = classifierDescriptor;
        this.isFinal = isFinal;
        this.debugName = debugName;
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeParameterDescriptor>(parameters2));
        this.supertypes = Collections.unmodifiableCollection(supertypes2);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list = this.parameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "getParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/TypeConstructorImpl", "getSupertypes"));
        }
        return collection;
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isDenotable() {
        return true;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return this.classifierDescriptor;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

