/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;

public final class QualifiedExpressionTranslator {
    private QualifiedExpressionTranslator() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context2, boolean forceOrderOfEvaluation) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context2);
        if (forceOrderOfEvaluation && receiver != null) {
            TemporaryVariable temporaryVariable = context2.declareTemporary(null);
            context2.addStatementToCurrentBlock(JsAstUtils.assignment(temporaryVariable.reference(), receiver).makeStmt());
            receiver = temporaryVariable.reference();
        }
        VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context2, PsiUtils.getNotNullSimpleNameSelector(expression), receiver);
        if (variableAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "getAccessTranslator"));
        }
        return variableAccessTranslator;
    }

    @NotNull
    public static JsNode translateQualifiedExpression(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context2);
        JetExpression selector = PsiUtils.getSelector(expression);
        JsNode jsNode = QualifiedExpressionTranslator.dispatchToCorrectTranslator(receiver, selector, context2);
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateQualifiedExpression"));
        }
        return jsNode;
    }

    @NotNull
    private static JsNode dispatchToCorrectTranslator(@Nullable JsExpression receiver, @NotNull JetExpression selector, @NotNull TranslationContext context2) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
        }
        if (ReferenceTranslator.canBePropertyAccess(selector, context2)) {
            assert (selector instanceof JetSimpleNameExpression) : "Selectors for properties must be simple names.";
            JsExpression jsExpression = VariableAccessTranslator.newInstance(context2, (JetSimpleNameExpression)selector, receiver).translateAsGet();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        if (selector instanceof JetCallExpression) {
            if (CallExpressionTranslator.shouldBeInlined((JetCallExpression)selector, context2) && BindingContextUtilPackage.isUsedAsExpression(selector, context2.bindingContext())) {
                TemporaryVariable temporaryVariable = context2.declareTemporary(null);
                JsNode result2 = QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver, selector, context2);
                assert (result2 instanceof JsExpression);
                JsExpression assignment = JsAstUtils.assignment(temporaryVariable.reference(), (JsExpression)result2);
                context2.addStatementToCurrentBlock(assignment.makeStmt());
                JsNameRef jsNameRef = temporaryVariable.reference();
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
                }
                return jsNameRef;
            }
            JsNode jsNode = QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver, selector, context2);
            if (jsNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsNode;
        }
        if (selector instanceof JetSimpleNameExpression) {
            JsExpression jsExpression = ReferenceTranslator.translateSimpleNameWithQualifier((JetSimpleNameExpression)selector, receiver, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "dispatchToCorrectTranslator"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + selector.getText()));
    }

    @NotNull
    private static JsNode invokeCallExpressionTranslator(@Nullable JsExpression receiver, @NotNull JetExpression selector, @NotNull TranslationContext context2) {
        JsNode jsNode;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        try {
            jsNode = CallExpressionTranslator.translate((JetCallExpression)selector, receiver, context2);
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(selector, e);
        }
        if (jsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "invokeCallExpressionTranslator"));
        }
        return jsNode;
    }

    @Nullable
    private static JsExpression translateReceiver(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateReceiver"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "translateReceiver"));
        }
        JetExpression receiverExpression = expression.getReceiverExpression();
        if (QualifiedExpressionTranslator.isFullQualifierForExpression(receiverExpression, context2)) {
            return null;
        }
        return Translation.translateAsExpression(receiverExpression, context2);
    }

    private static boolean isFullQualifierForExpression(@Nullable JetExpression receiverExpression, @NotNull TranslationContext context2) {
        DeclarationDescriptor descriptorForReferenceExpression;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/QualifiedExpressionTranslator", "isFullQualifierForExpression"));
        }
        if (receiverExpression == null) {
            return false;
        }
        if (receiverExpression instanceof JetReferenceExpression && (descriptorForReferenceExpression = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), (JetReferenceExpression)receiverExpression)) instanceof PackageViewDescriptor) {
            return true;
        }
        if (receiverExpression instanceof JetQualifiedExpression) {
            return QualifiedExpressionTranslator.isFullQualifierForExpression(((JetQualifiedExpression)receiverExpression).getSelectorExpression(), context2);
        }
        return false;
    }
}

