/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InliningInstructionAdapter;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.RegeneratedLambdaFieldRemapper;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class RemapVisitor
extends InliningInstructionAdapter {
    private final LocalVarRemapper remapper;
    private final FieldRemapper nodeRemapper;
    private final InstructionAdapter instructionAdapter;

    protected RemapVisitor(MethodVisitor mv, LocalVarRemapper localVarRemapper, FieldRemapper nodeRemapper) {
        super(mv);
        this.instructionAdapter = new InstructionAdapter(mv);
        this.remapper = localVarRemapper;
        this.nodeRemapper = nodeRemapper;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.remapper.visitIincInsn(var, increment, this.mv);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.remapper.visitVarInsn(opcode, var, this.instructionAdapter);
    }

    @Override
    public void visitLocalVariable(@NotNull String name, @NotNull String desc, String signature, @NotNull Label start, @NotNull Label end, int index2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        this.remapper.visitLocalVariable(name, desc, signature, start, end, index2, this.mv);
    }

    @Override
    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitFieldInsn"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitFieldInsn"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitFieldInsn"));
        }
        if (name.startsWith("$$$")) {
            if (this.nodeRemapper instanceof RegeneratedLambdaFieldRemapper || this.nodeRemapper.isRoot()) {
                FieldInsnNode fin = new FieldInsnNode(opcode, owner, name, desc);
                StackValue inline2 = this.nodeRemapper.getFieldForInline(fin, null);
                assert (inline2 != null) : "Captured field should have not null stackValue " + fin;
                inline2.put(inline2.type, this);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitAnnotation"));
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitParameterAnnotation"));
        }
        return null;
    }
}

