/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.InlineStrategy;
import org.jetbrains.kotlin.builtins.InlineUtil;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.DefaultProcessor;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InliningInstructionAdapter;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodInliner;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ParametersBuilder;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParameterMappings;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.RootInliningContext;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodeWrapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

public class InlineCodegen
extends CallGenerator {
    private final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final SimpleFunctionDescriptor functionDescriptor;
    private final JvmMethodSignature jvmSignature;
    private final JetElement callElement;
    private final MethodContext context;
    private final ExpressionCodegen codegen;
    private final boolean asFunctionInline;
    private final int initialFrameSize;
    private final boolean isSameModule;
    protected final ParametersBuilder invocationParamBuilder;
    protected final Map<Integer, LambdaInfo> expressionMap;
    private final ReifiedTypeInliner reifiedTypeInliner;
    private LambdaInfo activeLambda;
    private final SourceMapper sourceMapper;

    public InlineCodegen(@NotNull ExpressionCodegen codegen, @NotNull GenerationState state, @NotNull SimpleFunctionDescriptor functionDescriptor, @NotNull JetElement callElement, @Nullable ReifiedTypeParameterMappings typeParameterMappings) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "<init>"));
        }
        this.invocationParamBuilder = ParametersBuilder.newBuilder();
        this.expressionMap = new HashMap<Integer, LambdaInfo>();
        assert (functionDescriptor.getInlineStrategy().isInline()) : "InlineCodegen could inline only inline function but " + functionDescriptor;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.codegen = codegen;
        this.callElement = callElement;
        this.functionDescriptor = functionDescriptor.getOriginal();
        this.reifiedTypeInliner = new ReifiedTypeInliner(typeParameterMappings);
        this.initialFrameSize = codegen.getFrameMap().getCurrentSize();
        this.context = (MethodContext)InlineCodegen.getContext(functionDescriptor, state);
        this.jvmSignature = this.typeMapper.mapSignature(functionDescriptor, this.context.getContextKind());
        InlineStrategy inlineStrategy = codegen.getContext().isInlineFunction() ? InlineStrategy.IN_PLACE : functionDescriptor.getInlineStrategy();
        this.asFunctionInline = false;
        this.isSameModule = JvmCodegenUtil.isCallInsideSameModuleAsDeclared(functionDescriptor, codegen.getContext(), state.getOutDirectory());
        this.sourceMapper = codegen.getParentCodegen().getOrCreateSourceMapper();
    }

    @Override
    public void genCallWithoutAssertions(@NotNull CallableMethod callableMethod, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallWithoutAssertions"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallWithoutAssertions"));
        }
        this.genCall(callableMethod, null, false, codegen);
    }

    @Override
    public void genCallInner(@NotNull CallableMethod callableMethod, @Nullable ResolvedCall<?> resolvedCall, boolean callDefault, @NotNull ExpressionCodegen codegen) {
        if (callableMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallInner"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genCallInner"));
        }
        SMAPAndMethodNode nodeAndSmap = null;
        try {
            nodeAndSmap = this.createMethodNode(callDefault);
            this.endCall(this.inlineCall(nodeAndSmap));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            boolean generateNodeText = !(e instanceof InlineException);
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.codegen.getContext().getContextDescriptor());
            throw new CompilationException("Couldn't inline method call '" + this.functionDescriptor.getName() + "' into \n" + (element != null ? element.getText() : "null psi element " + this.codegen.getContext().getContextDescriptor()) + (generateNodeText ? "\ncause: " + InlineCodegenUtil.getNodeText(nodeAndSmap != null ? nodeAndSmap.getNode() : null) : ""), e, this.callElement);
        }
    }

    private void endCall(@NotNull InlineResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "endCall"));
        }
        this.leaveTemps();
        this.codegen.propagateChildReifiedTypeParametersUsages(result2.getReifiedTypeParametersUsages());
        this.state.getFactory().removeInlinedClasses(result2.getClassesToRemove());
    }

    @NotNull
    private SMAPAndMethodNode createMethodNode(boolean callDefault) throws ClassNotFoundException, IOException {
        SMAPAndMethodNode nodeAndSMAP;
        JvmMethodSignature jvmSignature = this.typeMapper.mapSignature(this.functionDescriptor, this.context.getContextKind());
        Method asmMethod = callDefault ? this.typeMapper.mapDefaultMethod(this.functionDescriptor, this.context.getContextKind(), this.context) : jvmSignature.getAsmMethod();
        if (this.functionDescriptor instanceof DeserializedSimpleFunctionDescriptor) {
            ClassId containerClassId = InlineCodegenUtil.getContainerClassIdForInlineCallable((DeserializedSimpleFunctionDescriptor)this.functionDescriptor);
            VirtualFile file = InlineCodegenUtil.getVirtualFileForCallable(containerClassId, this.state);
            if (this.functionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
                containerClassId = PackageClassUtils.getPackageClassId(containerClassId.getPackageFqName());
            }
            if ((nodeAndSMAP = InlineCodegenUtil.getMethodNode(file.contentsToByteArray(), asmMethod.getName(), asmMethod.getDescriptor(), containerClassId)) == null) {
                throw new RuntimeException("Couldn't obtain compiled function body for " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
        } else {
            SMAP smap;
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(this.functionDescriptor);
            if (element == null || !(element instanceof JetNamedFunction)) {
                throw new RuntimeException("Couldn't find declaration for function " + InlineCodegen.descriptorName(this.functionDescriptor));
            }
            JetNamedFunction inliningFunction = (JetNamedFunction)element;
            MethodNode node = new MethodNode(327680, AsmUtil.getMethodAsmFlags(this.functionDescriptor, this.context.getContextKind()) | (callDefault ? 8 : 0), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), null);
            MethodVisitor maxCalcAdapter = InlineCodegenUtil.wrapWithMaxLocalCalc(node);
            MethodContext methodContext = this.context.getParentContext().intoFunction(this.functionDescriptor);
            if (callDefault) {
                Type ownerType = this.typeMapper.mapOwner(this.functionDescriptor, false);
                FakeMemberCodegen parentCodegen = new FakeMemberCodegen(this.codegen.getParentCodegen(), inliningFunction, (FieldOwnerContext)methodContext.getParentContext(), ownerType.getInternalName());
                FunctionCodegen.generateDefaultImplBody(methodContext, this.functionDescriptor, maxCalcAdapter, DefaultParameterValueLoader.DEFAULT, inliningFunction, parentCodegen);
                smap = InlineCodegen.createSMAPWithDefaultMapping(inliningFunction, parentCodegen.getOrCreateSourceMapper().getResultMappings());
            } else {
                smap = this.generateMethodBody(maxCalcAdapter, this.functionDescriptor, methodContext, inliningFunction, jvmSignature, false);
            }
            nodeAndSMAP = new SMAPAndMethodNode(node, smap);
            maxCalcAdapter.visitMaxs(-1, -1);
            maxCalcAdapter.visitEnd();
        }
        SMAPAndMethodNode sMAPAndMethodNode = nodeAndSMAP;
        if (sMAPAndMethodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createMethodNode"));
        }
        return sMAPAndMethodNode;
    }

    private InlineResult inlineCall(SMAPAndMethodNode nodeAndSmap) {
        MethodNode node = nodeAndSmap.getNode();
        ReifiedTypeParametersUsages reificationResult = this.reifiedTypeInliner.reifyInstructions(node.instructions);
        this.generateClosuresBodies();
        this.putClosureParametersOnStack();
        InlineCodegenUtil.addInlineMarker(this.codegen.v, true);
        Parameters parameters2 = this.invocationParamBuilder.buildParameters();
        RootInliningContext info = new RootInliningContext(this.expressionMap, this.state, this.codegen.getInlineNameGenerator().subGenerator(this.functionDescriptor.getName().asString()), this.codegen.getContext(), this.callElement, this.codegen.getParentCodegen().getClassName(), this.reifiedTypeInliner);
        MethodInliner inliner = new MethodInliner(node, parameters2, info, new FieldRemapper(null, null, parameters2), this.isSameModule, "Method inlining " + this.callElement.getText(), this.createNestedSourceMapper(nodeAndSmap));
        LocalVarRemapper remapper = new LocalVarRemapper(parameters2, this.initialFrameSize);
        MethodNode adapter = InlineCodegenUtil.createEmptyMethodNode();
        adapter.visitInsn(0);
        InlineResult result2 = inliner.doInline(adapter, remapper, true, LabelOwner.SKIP_ALL);
        result2.getReifiedTypeParametersUsages().mergeAll(reificationResult);
        LabelOwner labelOwner = new LabelOwner(){
            final CallableMemberDescriptor descriptor;
            final boolean isLambda;
            {
                this.descriptor = (CallableMemberDescriptor)InlineCodegen.this.codegen.getContext().getContextDescriptor();
                this.isLambda = DescriptorUtils.isFunctionExpression(this.descriptor) || DescriptorUtils.isFunctionLiteral(this.descriptor);
            }

            @Override
            public boolean isMyLabel(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$1", "isMyLabel"));
                }
                if ("$$$$$ROOT$$$$$".equals(name)) {
                    return !this.isLambda;
                }
                return this.descriptor.getName().asString().equals(name);
            }
        };
        List<MethodInliner.PointForExternalFinallyBlocks> infos = MethodInliner.processReturns(adapter, labelOwner, true, null);
        this.generateAndInsertFinallyBlocks(adapter, infos);
        adapter.accept(new InliningInstructionAdapter(this.codegen.v));
        InlineCodegenUtil.addInlineMarker(this.codegen.v, false);
        return result2;
    }

    private void generateClosuresBodies() {
        for (LambdaInfo info : this.expressionMap.values()) {
            info.setNode(this.generateLambdaBody(info));
        }
    }

    private SMAPAndMethodNode generateLambdaBody(LambdaInfo info) {
        JetFunctionLiteral declaration = info.getFunctionLiteral();
        FunctionDescriptor descriptor = info.getFunctionDescriptor();
        MethodContext parentContext = this.codegen.getContext();
        MethodContext context2 = parentContext.intoClosure(descriptor, this.codegen, this.typeMapper).intoInlinedLambda(descriptor);
        JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(descriptor);
        Method asmMethod = jvmMethodSignature.getAsmMethod();
        MethodNode methodNode = new MethodNode(327680, AsmUtil.getMethodAsmFlags(descriptor, context2.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmMethodSignature.getGenericsSignature(), null);
        MethodVisitor adapter = InlineCodegenUtil.wrapWithMaxLocalCalc(methodNode);
        SMAP smap = this.generateMethodBody(adapter, descriptor, context2, declaration, jvmMethodSignature, true);
        adapter.visitMaxs(-1, -1);
        return new SMAPAndMethodNode(methodNode, smap);
    }

    private SMAP generateMethodBody(@NotNull MethodVisitor adapter, @NotNull FunctionDescriptor descriptor, @NotNull MethodContext context2, @NotNull JetDeclarationWithBody declaration, @NotNull JvmMethodSignature jvmMethodSignature, boolean isLambda) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "generateMethodBody"));
        }
        FakeMemberCodegen parentCodegen = new FakeMemberCodegen(this.codegen.getParentCodegen(), declaration, (FieldOwnerContext)context2.getParentContext(), isLambda ? this.codegen.getParentCodegen().getClassName() : this.typeMapper.mapOwner(descriptor, false).getInternalName());
        FunctionCodegen.generateMethodBody(adapter, descriptor, context2, jvmMethodSignature, new FunctionGenerationStrategy.FunctionDefault(this.state, descriptor, declaration), parentCodegen);
        return InlineCodegen.createSMAPWithDefaultMapping(declaration, parentCodegen.getOrCreateSourceMapper().getResultMappings());
    }

    private static SMAP createSMAPWithDefaultMapping(@NotNull JetDeclarationWithBody declaration, @NotNull List<FileMapping> mappings) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createSMAPWithDefaultMapping"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createSMAPWithDefaultMapping"));
        }
        PsiFile containingFile = declaration.getContainingFile();
        Integer lineNumbers2 = CodegenUtil.getLineNumberForElement(containingFile, true);
        assert (lineNumbers2 != null) : "Couldn't extract line count in " + containingFile;
        return new SMAP(mappings);
    }

    @Override
    public void afterParameterPut(@NotNull Type type2, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "afterParameterPut"));
        }
        this.putCapturedInLocal(type2, stackValue, valueParameterDescriptor, -1);
    }

    private void putCapturedInLocal(@NotNull Type type2, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor valueParameterDescriptor, int capturedParamIndex) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedInLocal"));
        }
        if (!this.asFunctionInline && Type.VOID_TYPE != type2) {
            ParameterInfo info;
            StackValue remappedIndex;
            boolean couldBeRemapped = !this.shouldPutValue(type2, stackValue, valueParameterDescriptor);
            StackValue stackValue2 = remappedIndex = couldBeRemapped ? stackValue : null;
            if (capturedParamIndex >= 0) {
                CapturedParamDesc capturedParamInfoInLambda = this.activeLambda.getCapturedVars().get(capturedParamIndex);
                info = this.invocationParamBuilder.addCapturedParam(capturedParamInfoInLambda, capturedParamInfoInLambda.getFieldName());
                info.setRemapValue(remappedIndex);
            } else {
                info = this.invocationParamBuilder.addNextParameter(type2, false, remappedIndex);
            }
            this.putParameterOnStack(info);
        }
    }

    public boolean shouldPutValue(@NotNull Type type2, @Nullable StackValue stackValue, @Nullable ValueParameterDescriptor descriptor) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "shouldPutValue"));
        }
        if (stackValue == null) {
            return true;
        }
        if (AsmUtil.isPrimitive(type2) != AsmUtil.isPrimitive(stackValue.type)) {
            return true;
        }
        if (stackValue instanceof StackValue.Local) {
            return false;
        }
        StackValue receiver = null;
        if (stackValue instanceof StackValue.Field) {
            receiver = ((StackValue.Field)stackValue).receiver;
        } else if (stackValue instanceof StackValue.FieldForSharedVar) {
            receiver = ((StackValue.Field)((StackValue.FieldForSharedVar)stackValue).receiver).receiver;
        }
        if (!(receiver instanceof StackValue.Local)) {
            return true;
        }
        return !this.codegen.getContext().isInliningLambda() || descriptor == null || InlineUtil.hasNoinlineAnnotation(descriptor);
    }

    private void putParameterOnStack(ParameterInfo ... infos) {
        ParameterInfo info;
        int i;
        int[] index2 = new int[infos.length];
        for (i = 0; i < infos.length; ++i) {
            info = infos[i];
            index2[i] = !info.isSkippedOrRemapped() ? this.codegen.getFrameMap().enterTemp(info.getType()) : -1;
        }
        for (i = infos.length - 1; i >= 0; --i) {
            info = infos[i];
            if (info.isSkippedOrRemapped()) continue;
            Type type2 = info.type;
            StackValue.local(index2[i], type2).store(StackValue.onStack(type2), this.codegen.v);
        }
    }

    @Override
    public void putHiddenParams() {
        List<JvmMethodParameterSignature> valueParameters = this.jvmSignature.getValueParameters();
        if (!InlineCodegen.isStaticMethod(this.functionDescriptor, this.context)) {
            this.invocationParamBuilder.addNextParameter(AsmTypes.OBJECT_TYPE, false, null);
        }
        for (JvmMethodParameterSignature param : valueParameters) {
            if (param.getKind() == JvmMethodParameterKind.VALUE) break;
            this.invocationParamBuilder.addNextParameter(param.getAsmType(), false, null);
        }
        List<ParameterInfo> infos = this.invocationParamBuilder.listNotCaptured();
        this.putParameterOnStack(infos.toArray(new ParameterInfo[infos.size()]));
    }

    public void leaveTemps() {
        FrameMap frameMap = this.codegen.getFrameMap();
        List<ParameterInfo> infos = this.invocationParamBuilder.listAllParams();
        ListIterator<ParameterInfo> iterator2 = infos.listIterator(infos.size());
        while (iterator2.hasPrevious()) {
            ParameterInfo param = iterator2.previous();
            if (param.isSkippedOrRemapped()) continue;
            frameMap.leaveTemp(param.type);
        }
    }

    public static boolean isInliningClosure(JetExpression expression, ValueParameterDescriptor valueParameterDescriptora) {
        JetExpression deparenthesize = JetPsiUtil.deparenthesize(expression);
        return deparenthesize instanceof JetFunctionLiteralExpression && !InlineUtil.hasNoinlineAnnotation(valueParameterDescriptora);
    }

    public void rememberClosure(JetExpression expression, Type type2) {
        JetFunctionLiteralExpression lambda2 = (JetFunctionLiteralExpression)JetPsiUtil.deparenthesize(expression);
        assert (lambda2 != null) : "Couldn't find lambda in " + expression.getText();
        String labelNameIfPresent = null;
        PsiElement parent = lambda2.getParent();
        if (parent instanceof JetLabeledExpression) {
            labelNameIfPresent = ((JetLabeledExpression)parent).getLabelName();
        }
        LambdaInfo info = new LambdaInfo(lambda2, this.typeMapper, labelNameIfPresent);
        ParameterInfo closureInfo = this.invocationParamBuilder.addNextParameter(type2, true, null);
        closureInfo.setLambda(info);
        this.expressionMap.put(closureInfo.getIndex(), info);
    }

    private void putClosureParametersOnStack() {
        Iterator<LambdaInfo> i$ = this.expressionMap.values().iterator();
        while (i$.hasNext()) {
            LambdaInfo next;
            this.activeLambda = next = i$.next();
            this.codegen.pushClosureOnStack(next.getClassDescriptor(), true, this);
        }
        this.activeLambda = null;
    }

    public static CodegenContext getContext(DeclarationDescriptor descriptor, GenerationState state) {
        if (descriptor instanceof PackageFragmentDescriptor) {
            return new PackageContext((PackageFragmentDescriptor)descriptor, null, null);
        }
        CodegenContext parent = InlineCodegen.getContext(descriptor.getContainingDeclaration(), state);
        if (descriptor instanceof ClassDescriptor) {
            OwnerKind kind = DescriptorUtils.isTrait(descriptor) ? OwnerKind.TRAIT_IMPL : OwnerKind.IMPLEMENTATION;
            return parent.intoClass((ClassDescriptor)descriptor, kind, state);
        }
        if (descriptor instanceof FunctionDescriptor) {
            return parent.intoFunction((FunctionDescriptor)descriptor);
        }
        throw new IllegalStateException("Couldn't build context for " + InlineCodegen.descriptorName(descriptor));
    }

    private static boolean isStaticMethod(FunctionDescriptor functionDescriptor, MethodContext context2) {
        return (AsmUtil.getMethodAsmFlags(functionDescriptor, context2.getContextKind()) & 8) != 0;
    }

    private static String descriptorName(DeclarationDescriptor descriptor) {
        return DescriptorRenderer.SHORT_NAMES_IN_TYPES.render(descriptor);
    }

    @Override
    public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (argumentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "genValueAndPut"));
        }
        if (InlineCodegen.isInliningClosure(argumentExpression, valueParameterDescriptor)) {
            this.rememberClosure(argumentExpression, parameterType);
        } else {
            StackValue value = this.codegen.gen(argumentExpression);
            this.putValueIfNeeded(valueParameterDescriptor, parameterType, value);
        }
    }

    @Override
    public void putValueIfNeeded(@Nullable ValueParameterDescriptor valueParameterDescriptor, @NotNull Type parameterType, @NotNull StackValue value) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putValueIfNeeded"));
        }
        if (this.shouldPutValue(parameterType, value, valueParameterDescriptor)) {
            value.put(parameterType, this.codegen.v);
        }
        this.afterParameterPut(parameterType, value, valueParameterDescriptor);
    }

    @Override
    public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
        if (stackValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "putCapturedValueOnStack"));
        }
        if (this.shouldPutValue(stackValue.type, stackValue, null)) {
            stackValue.put(stackValue.type, this.codegen.v);
        }
        this.putCapturedInLocal(stackValue.type, stackValue, null, paramIndex);
    }

    public void generateAndInsertFinallyBlocks(MethodNode intoNode, List<MethodInliner.PointForExternalFinallyBlocks> insertPoints) {
        if (!this.codegen.hasFinallyBlocks()) {
            return;
        }
        HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks> extensionPoints = new HashMap<AbstractInsnNode, MethodInliner.PointForExternalFinallyBlocks>();
        for (MethodInliner.PointForExternalFinallyBlocks insertPoint : insertPoints) {
            extensionPoints.put(insertPoint.beforeIns, insertPoint);
        }
        DefaultProcessor processor = new DefaultProcessor(intoNode);
        for (AbstractInsnNode curInstr = intoNode.instructions.getFirst(); curInstr != null; curInstr = curInstr.getNext()) {
            processor.updateCoveringTryBlocks(curInstr, true);
            MethodInliner.PointForExternalFinallyBlocks extension = (MethodInliner.PointForExternalFinallyBlocks)extensionPoints.get(curInstr);
            if (extension == null) continue;
            Label start = new Label();
            Label end = new Label();
            MethodNode finallyNode = InlineCodegenUtil.createEmptyMethodNode();
            finallyNode.visitLabel(start);
            ExpressionCodegen finallyCodegen = new ExpressionCodegen(finallyNode, this.codegen.getFrameMap(), this.codegen.getReturnType(), this.codegen.getContext(), this.codegen.getState(), this.codegen.getParentCodegen());
            finallyCodegen.addBlockStackElementsForNonLocalReturns(this.codegen.getBlockStackElements());
            finallyCodegen.generateFinallyBlocksIfNeeded(extension.returnType);
            finallyNode.visitLabel(end);
            InlineCodegenUtil.insertNodeBefore(finallyNode, intoNode, curInstr);
            List blocks = processor.getCoveringFromInnermost();
            ListIterator iterator2 = blocks.listIterator(blocks.size());
            while (iterator2.hasPrevious()) {
                TryCatchBlockNodeWrapper previous = (TryCatchBlockNodeWrapper)iterator2.previous();
                LabelNode oldStart = previous.getStartLabel();
                TryCatchBlockNode node = previous.getNode();
                node.start = (LabelNode)end.info;
                processor.remapStartLabel(oldStart, previous);
                TryCatchBlockNode additionalNode = new TryCatchBlockNode(oldStart, (LabelNode)start.info, node.handler, node.type);
                processor.addNode(additionalNode);
            }
        }
        processor.sortTryCatchBlocks();
        List nodes = processor.getNonEmptyNodes();
        intoNode.tryCatchBlocks.clear();
        for (TryCatchBlockNodeWrapper node : nodes) {
            intoNode.tryCatchBlocks.add(node.getNode());
        }
    }

    private SourceMapper createNestedSourceMapper(@NotNull SMAPAndMethodNode nodeAndSmap) {
        if (nodeAndSmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeAndSmap", "org/jetbrains/kotlin/codegen/inline/InlineCodegen", "createNestedSourceMapper"));
        }
        return new NestedSourceMapper(this.sourceMapper, nodeAndSmap.getRanges(), nodeAndSmap.getClassSMAP().getSourceInfo());
    }

    private static class FakeMemberCodegen
    extends MemberCodegen {
        private final MemberCodegen delegate;
        @NotNull
        private final String className;

        public FakeMemberCodegen(@NotNull MemberCodegen wrapped, @NotNull JetElement declaration, @NotNull FieldOwnerContext codegenContext, @NotNull String className) {
            if (wrapped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (codegenContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "<init>"));
            }
            super(wrapped, declaration, codegenContext);
            this.delegate = wrapped;
            this.className = className;
        }

        @Override
        protected void generateDeclaration() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateBody() {
            throw new IllegalStateException();
        }

        @Override
        protected void generateKotlinAnnotation() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public NameGenerator getInlineNameGenerator() {
            NameGenerator nameGenerator = this.delegate.getInlineNameGenerator();
            if (nameGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "getInlineNameGenerator"));
            }
            return nameGenerator;
        }

        @Override
        @NotNull
        public String getClassName() {
            String string = this.className;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InlineCodegen$FakeMemberCodegen", "getClassName"));
            }
            return string;
        }
    }
}

