/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.reflect.ReflectionTypes;

public class JvmRuntimeTypes {
    private final ReflectionTypes reflectionTypes;
    private final ClassDescriptor functionImpl;
    private final ClassDescriptor memberFunctionImpl;
    private final ClassDescriptor extensionFunctionImpl;

    public JvmRuntimeTypes(@NotNull ReflectionTypes reflectionTypes) {
        if (reflectionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reflectionTypes", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "<init>"));
        }
        this.reflectionTypes = reflectionTypes;
        MutablePackageFragmentDescriptor kotlinJvmInternal = new MutablePackageFragmentDescriptor(TopDownAnalyzerFacadeForJVM.createJavaModule("<jvm functions impl>"), new FqName("kotlin.jvm.internal"));
        this.functionImpl = JvmRuntimeTypes.createClass(kotlinJvmInternal, "FunctionImpl", "out R");
        this.memberFunctionImpl = JvmRuntimeTypes.createClass(kotlinJvmInternal, "MemberFunctionImpl", "in T", "out R");
        this.extensionFunctionImpl = JvmRuntimeTypes.createClass(kotlinJvmInternal, "ExtensionFunctionImpl", "in T", "out R");
    }

    @NotNull
    private static ClassDescriptor createClass(@NotNull PackageFragmentDescriptor packageFragment, @NotNull String name, String ... typeParameters) {
        if (packageFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragment", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        MutableClassDescriptor descriptor = new MutableClassDescriptor(packageFragment, packageFragment.getMemberScope(), ClassKind.CLASS, false, Name.identifier(name), SourceElement.NO_SOURCE);
        ArrayList<TypeParameterDescriptor> typeParameterDescriptors2 = new ArrayList<TypeParameterDescriptor>(typeParameters.length);
        for (int i = 0; i < typeParameters.length; ++i) {
            String[] s = typeParameters[i].split(" ");
            Variance variance = Variance.valueOf(s[0].toUpperCase() + "_VARIANCE");
            String typeParameterName = s[1];
            TypeParameterDescriptorImpl typeParameter = TypeParameterDescriptorImpl.createForFurtherModification(descriptor, Annotations.EMPTY, false, variance, Name.identifier(typeParameterName), i, SourceElement.NO_SOURCE);
            typeParameter.setInitialized();
            typeParameterDescriptors2.add(typeParameter);
        }
        descriptor.setModality(Modality.FINAL);
        descriptor.setVisibility(Visibilities.PUBLIC);
        descriptor.setTypeParameterDescriptors(typeParameterDescriptors2);
        descriptor.createTypeConstructor();
        MutableClassDescriptor mutableClassDescriptor = descriptor;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "createClass"));
        }
        return mutableClassDescriptor;
    }

    @NotNull
    public Collection<JetType> getSupertypesForClosure(@NotNull FunctionDescriptor descriptor) {
        ClassDescriptor classDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getExtensionReceiverParameter();
        ArrayList<TypeProjectionImpl> typeArguments = new ArrayList<TypeProjectionImpl>(2);
        if (receiverParameter != null) {
            classDescriptor = this.extensionFunctionImpl;
            typeArguments.add(new TypeProjectionImpl(receiverParameter.getType()));
        } else {
            classDescriptor = this.functionImpl;
        }
        typeArguments.add(new TypeProjectionImpl(descriptor.getReturnType()));
        JetTypeImpl functionImplType = new JetTypeImpl(classDescriptor.getDefaultType().getAnnotations(), classDescriptor.getTypeConstructor(), false, typeArguments, classDescriptor.getMemberScope(typeArguments));
        JetType functionType = KotlinBuiltIns.getInstance().getFunctionType(Annotations.EMPTY, receiverParameter == null ? null : receiverParameter.getType(), ExpressionTypingUtils.getValueParametersTypes(descriptor.getValueParameters()), descriptor.getReturnType());
        List<JetType> list = Arrays.asList(functionImplType, functionType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForClosure"));
        }
        return list;
    }

    @NotNull
    public Collection<JetType> getSupertypesForFunctionReference(@NotNull FunctionDescriptor descriptor) {
        JetType receiverType;
        ClassDescriptor classDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForFunctionReference"));
        }
        ReceiverParameterDescriptor extensionReceiver2 = descriptor.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = descriptor.getDispatchReceiverParameter();
        ArrayList<TypeProjectionImpl> typeArguments = new ArrayList<TypeProjectionImpl>(2);
        if (extensionReceiver2 != null) {
            classDescriptor = this.extensionFunctionImpl;
            receiverType = extensionReceiver2.getType();
            typeArguments.add(new TypeProjectionImpl(receiverType));
        } else if (dispatchReceiver != null) {
            classDescriptor = this.memberFunctionImpl;
            receiverType = dispatchReceiver.getType();
            typeArguments.add(new TypeProjectionImpl(receiverType));
        } else {
            classDescriptor = this.functionImpl;
            receiverType = null;
        }
        typeArguments.add(new TypeProjectionImpl(descriptor.getReturnType()));
        JetTypeImpl functionImplType = new JetTypeImpl(classDescriptor.getDefaultType().getAnnotations(), classDescriptor.getTypeConstructor(), false, typeArguments, classDescriptor.getMemberScope(typeArguments));
        JetType kFunctionType = this.reflectionTypes.getKFunctionType(Annotations.EMPTY, receiverType, ExpressionTypingUtils.getValueParametersTypes(descriptor.getValueParameters()), descriptor.getReturnType(), extensionReceiver2 != null);
        List<JetType> list = Arrays.asList(functionImplType, kFunctionType);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmRuntimeTypes", "getSupertypesForFunctionReference"));
        }
        return list;
    }
}

