/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Iterator;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineOption;
import org.jetbrains.kotlin.builtins.InlineStrategy;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.EnumValue;

public class InlineUtil {
    public static boolean hasNoinlineAnnotation(@NotNull CallableDescriptor valueParameterDescriptor) {
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/kotlin/builtins/InlineUtil", "hasNoinlineAnnotation"));
        }
        return KotlinBuiltIns.containsAnnotation(valueParameterDescriptor, KotlinBuiltIns.getNoinlineClassAnnotationFqName());
    }

    @NotNull
    public static InlineStrategy getInlineType(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/InlineUtil", "getInlineType"));
        }
        ClassDescriptor inlineAnnotation = KotlinBuiltIns.getInstance().getInlineClassAnnotation();
        AnnotationDescriptor annotation2 = descriptor.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(inlineAnnotation));
        if (annotation2 == null) {
            InlineStrategy inlineStrategy = InlineStrategy.NOT_INLINE;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/InlineUtil", "getInlineType"));
            }
            return inlineStrategy;
        }
        CompileTimeConstant<?> argument = InlineUtil.getAnnotationSingleArgument(descriptor, inlineAnnotation);
        if (argument == null) {
            InlineStrategy inlineStrategy = InlineStrategy.AS_FUNCTION;
            if (inlineStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/InlineUtil", "getInlineType"));
            }
            return inlineStrategy;
        }
        assert (argument instanceof EnumValue) : "Inline annotation parameter should be enum entry but was: " + argument;
        String name = ((EnumValue)argument).getValue().getName().asString();
        InlineStrategy inlineStrategy = name.equals(InlineStrategy.IN_PLACE.name()) ? InlineStrategy.IN_PLACE : InlineStrategy.AS_FUNCTION;
        if (inlineStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/builtins/InlineUtil", "getInlineType"));
        }
        return inlineStrategy;
    }

    public static boolean hasOnlyLocalContinueAndBreak(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/InlineUtil", "hasOnlyLocalContinueAndBreak"));
        }
        return InlineUtil.hasInlineOption(descriptor, InlineOption.LOCAL_CONTINUE_AND_BREAK);
    }

    public static boolean hasOnlyLocalReturn(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/InlineUtil", "hasOnlyLocalReturn"));
        }
        return InlineUtil.hasInlineOption(descriptor, InlineOption.ONLY_LOCAL_RETURN);
    }

    private static boolean hasInlineOption(@NotNull ValueParameterDescriptor descriptor, @NotNull InlineOption option) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/builtins/InlineUtil", "hasInlineOption"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "org/jetbrains/kotlin/builtins/InlineUtil", "hasInlineOption"));
        }
        CompileTimeConstant<?> argument = InlineUtil.getAnnotationSingleArgument(descriptor, KotlinBuiltIns.getInstance().getInlineOptionsClassAnnotation());
        if (argument instanceof ArrayValue) {
            Object values = ((ArrayValue)argument).getValue();
            Iterator i$ = values.iterator();
            while (i$.hasNext()) {
                CompileTimeConstant value = (CompileTimeConstant)i$.next();
                if (!(value instanceof EnumValue) || !((EnumValue)value).getValue().getName().asString().equals(option.name())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static CompileTimeConstant<?> getAnnotationSingleArgument(@NotNull Annotated annotated, @NotNull ClassDescriptor annotationClass) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/builtins/InlineUtil", "getAnnotationSingleArgument"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "org/jetbrains/kotlin/builtins/InlineUtil", "getAnnotationSingleArgument"));
        }
        AnnotationDescriptor annotation2 = annotated.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(annotationClass));
        if (annotation2 != null) {
            return KotlinPackage.firstOrNull(annotation2.getAllValueArguments().values());
        }
        return null;
    }
}

