/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.IsRetina;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.UndoManager;
import org.jetbrains.annotations.NotNull;

public class UIUtil {
    private static final StyleSheet DEFAULT_HTML_KIT_CSS;
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE;
    private static final String[] STANDARD_FONT_SIZES;
    private static final GrayFilter DEFAULT_GRAY_FILTER;
    private static final GrayFilter DARCULA_GRAY_FILTER;
    public static final Pattern CLOSE_TAG_PATTERN;
    public static Key<Integer> KEEP_BORDER_SIDES;
    private static Key<UndoManager> UNDO_MANAGER;
    private static final AbstractAction REDO_ACTION;
    private static final AbstractAction UNDO_ACTION;
    private static final Logger LOG;
    private static final Color UNFOCUSED_SELECTION_COLOR;
    private static final Color ACTIVE_HEADER_COLOR;
    private static final Color INACTIVE_HEADER_COLOR;
    private static final Color BORDER_COLOR;
    public static final Color CONTRAST_BORDER_COLOR;
    public static final Color SIDE_PANEL_BACKGROUND;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Insets PANEL_REGULAR_INSETS;
    public static final Insets PANEL_SMALL_INSETS;
    public static final Border DEBUG_MARKER_BORDER;
    private static final HashMap<Color, BufferedImage> ourAppleDotSamples;
    private static volatile Pair<String, Integer> ourSystemFontData;
    private static final Ref<Boolean> ourRetina;
    private static final Map<Class, Ref<Method>> ourDefaultIconMethodsCache;
    public static final Color GTK_AMBIANCE_TEXT_COLOR;
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR;
    private static int THEME_BASED_TEXT_LCD_CONTRAST;
    private static int BEST_DARK_LCD_CONTRAST;
    private static int BEST_LIGHT_LCD_CONTRAST;
    private static final Color DECORATED_ROW_BG_COLOR;
    private static Map<String, String> ourRealFontFamilies;

    private UIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        if (Registry.is("new.retina.detection")) {
            return DetectRetinaKit.isRetina();
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                if (SystemInfo.isJavaVersionAtLeast("1.6.0_33") && SystemInfo.isAppleJvm) {
                    if (!"false".equals(System.getProperty("ide.mac.retina"))) {
                        ourRetina.set(IsRetina.isRetina());
                        return ourRetina.get();
                    }
                } else if (SystemInfo.isJavaVersionAtLeast("1.7.0_40") && SystemInfo.isOracleJvm) {
                    try {
                        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice device = env.getDefaultScreenDevice();
                        Integer scale = ReflectionUtil.getField(device.getClass(), device, Integer.TYPE, "scale");
                        if (scale != null && scale == 2) {
                            ourRetina.set(true);
                            return true;
                        }
                    }
                    catch (AWTError aWTError) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    public static <T> T getClientProperty(@NotNull JComponent component, @NotNull Key<T> key) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/ui/UIUtil", "getClientProperty"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/ui/UIUtil", "getClientProperty"));
        }
        return (T)component.getClientProperty(key);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListBackground() {
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            Color color = UIManager.getColor("List.background");
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        int n = i1 = i1 != x1 + 1 ? y + 2 : y + 1;
        while (i1 <= y1) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
            i1 += 2;
        }
        int n2 = i1 = i1 != y1 + 1 ? x1 - 2 : x1 - 1;
        while (i1 >= x) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
            i1 -= 2;
        }
        int n3 = i1 = i1 != x - 1 ? y1 - 2 : y1 - 1;
        while (i1 >= y) {
            UIUtil.drawLine(g, x, i1, x, i1);
            i1 -= 2;
        }
    }

    public static void setHintingForLCDText(Graphics2D g2d) {
        if (SystemInfo.isJetbrainsJvm && Registry.is("force.subpixel.hinting")) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            int registryLcdContrastValue = Registry.intValue("lcd.contrast.value");
            if (registryLcdContrastValue == THEME_BASED_TEXT_LCD_CONTRAST) {
                registryLcdContrastValue = UIUtil.isUnderDarcula() ? BEST_DARK_LCD_CONTRAST : BEST_LIGHT_LCD_CONTRAST;
            }
            if (registryLcdContrastValue < 100) {
                LOG.warn("Wrong value of text LCD contrast " + registryLcdContrastValue);
                registryLcdContrastValue = 100;
            } else if (registryLcdContrastValue > 250) {
                LOG.warn("Wrong value of text LCD contrast " + registryLcdContrastValue);
                registryLcdContrastValue = 250;
            }
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, registryLcdContrastValue);
        }
    }

    public static BufferedImage createImage(int width, int height, int type2) {
        if (UIUtil.isRetina()) {
            return RetinaImage.create(width, height, type2);
        }
        return new BufferedImage(width, height, type2);
    }

    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(x, y, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 0, 0, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, x, y, observer);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/ui/UIUtil", "invokeLaterIfNeeded"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            SwingUtilities.invokeLater(runnable2);
        }
    }

    static {
        HTMLEditorKit kit = new HTMLEditorKit();
        DEFAULT_HTML_KIT_CSS = kit.getStyleSheet();
        kit.setStyleSheet(null);
        X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

            @Override
            @NotNull
            protected Boolean compute() {
                Boolean bl;
                if (!SystemInfo.isXWindow) {
                    Boolean bl2 = false;
                    if (bl2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                    }
                    return bl2;
                }
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                    Method method = clazz.getMethod("isXRenderAvailable", new Class[0]);
                    bl = (Boolean)method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    Boolean bl3 = false;
                    if (bl3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                    }
                    return bl3;
                }
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                }
                return bl;
            }
        };
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        DEFAULT_GRAY_FILTER = new GrayFilter(true, 50);
        DARCULA_GRAY_FILTER = new GrayFilter(true, 30);
        CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
        KEEP_BORDER_SIDES = Key.create("keepBorderSides");
        UNDO_MANAGER = Key.create("undoManager");
        REDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager;
                Object source = e.getSource();
                UndoManager undoManager = manager = source instanceof JComponent ? (UndoManager)UIUtil.getClientProperty((JComponent)source, UNDO_MANAGER) : null;
                if (manager != null && manager.canRedo()) {
                    manager.redo();
                }
            }
        };
        UNDO_ACTION = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager manager;
                Object source = e.getSource();
                UndoManager undoManager = manager = source instanceof JComponent ? (UndoManager)UIUtil.getClientProperty((JComponent)source, UNDO_MANAGER) : null;
                if (manager != null && manager.canUndo()) {
                    manager.undo();
                }
            }
        };
        LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
        UNFOCUSED_SELECTION_COLOR = Gray._212;
        ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
        INACTIVE_HEADER_COLOR = Gray._128;
        BORDER_COLOR = Color.LIGHT_GRAY;
        CONTRAST_BORDER_COLOR = new JBColor(0x9B9B9B, 0x282828);
        SIDE_PANEL_BACKGROUND = new JBColor(new Color(15133680), new Color(4080460));
        AQUA_SEPARATOR_FOREGROUND_COLOR = new JBColor(Gray._190, Gray.x51);
        AQUA_SEPARATOR_BACKGROUND_COLOR = new JBColor(Gray._240, Gray.x51);
        TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
        PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
        PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
        DEBUG_MARKER_BORDER = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics g2 = g.create();
                try {
                    g2.setColor(JBColor.RED);
                    UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
        ourAppleDotSamples = new HashMap();
        ourSystemFontData = null;
        ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
        ourDefaultIconMethodsCache = new ConcurrentHashMap<Class, Ref<Method>>();
        GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
        GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
        THEME_BASED_TEXT_LCD_CONTRAST = 0;
        BEST_DARK_LCD_CONTRAST = 250;
        BEST_LIGHT_LCD_CONTRAST = 100;
        DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));
        ourRealFontFamilies = null;
    }

    private static final class DetectRetinaKit {
        private static final WeakHashMap<GraphicsDevice, Boolean> devicesToRetinaSupportCacheMap = new WeakHashMap();

        private static boolean isOracleMacRetinaDevice(GraphicsDevice device) {
            if (SystemInfo.isAppleJvm) {
                return false;
            }
            Boolean isRetina = (Boolean)devicesToRetinaSupportCacheMap.get(device);
            if (isRetina != null) {
                return isRetina;
            }
            Method getScaleFactorMethod = null;
            try {
                getScaleFactorMethod = Class.forName("sun.awt.CGraphicsDevice").getMethod("getScaleFactor", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            catch (NoSuchMethodException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): not an Oracle Mac JDK or API has been changed");
            }
            try {
                isRetina = getScaleFactorMethod == null || (Integer)getScaleFactorMethod.invoke((Object)device, new Object[0]) != 1;
            }
            catch (IllegalAccessException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Access issue");
                isRetina = false;
            }
            catch (InvocationTargetException e) {
                LOG.debug("CGraphicsDevice.getScaleFactor(): Invocation issue");
                isRetina = false;
            }
            devicesToRetinaSupportCacheMap.put((Object)device, (Object)isRetina);
            return isRetina;
        }

        private static boolean hasAppleRetinaDevice() {
            return ((Float)Toolkit.getDefaultToolkit().getDesktopProperty("apple.awt.contentScaleFactor")).floatValue() != 1.0f;
        }

        private static boolean isRetina() {
            if (SystemInfo.isAppleJvm) {
                return DetectRetinaKit.hasAppleRetinaDevice();
            }
            if (SystemInfo.isMac) {
                GraphicsDevice[] devices;
                GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice device : devices = e.getScreenDevices()) {
                    if (!DetectRetinaKit.isOracleMacRetinaDevice(device)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

