/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.CharArrayReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOMUtil {
    private static final ThreadLocal<java.lang.ref.SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    public static void internElement(@NotNull Element element, @NotNull StringInterner interner) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        if (interner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interner", "com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        element.setName(JDOMUtil.intern(interner, element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(JDOMUtil.intern(interner, attr.getName()));
            attr.setValue(JDOMUtil.intern(interner, attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof Element) {
                Element e = (Element)o;
                JDOMUtil.internElement(e, interner);
                continue;
            }
            if (o instanceof Text) {
                Text text = (Text)o;
                text.setText(JDOMUtil.intern(interner, text.getText()));
                continue;
            }
            if (o instanceof Comment) {
                Comment comment = (Comment)o;
                comment.setText(JDOMUtil.intern(interner, comment.getText()));
                continue;
            }
            throw new IllegalArgumentException("Wrong node: " + o);
        }
    }

    @NotNull
    private static String intern(@NotNull StringInterner interner, @NotNull String s) {
        if (interner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interner", "com/intellij/openapi/util/JDOMUtil", "intern"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/JDOMUtil", "intern"));
        }
        String string = interner.intern(s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "intern"));
        }
        return string;
    }

    private static SAXBuilder getSaxBuilder() {
        java.lang.ref.SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    InputSource inputSource = new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                    if (inputSource == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$1", "resolveEntity"));
                    }
                    return inputSource;
                }
            });
            ourSaxBuilder.set(new java.lang.ref.SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.getSaxBuilder().build(reader);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream2) throws JDOMException, IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(new InputStreamReader(stream2, CharsetToolkit.UTF8_CHARSET));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        InputStream stream2 = clazz.getResourceAsStream(resource);
        if (stream2 == null) {
            throw new FileNotFoundException(resource);
        }
        Document document = JDOMUtil.loadDocument(stream2);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadResourceDocument"));
        }
        return document;
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }
}

