/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.NotNull;

public class Conditions {
    public static Condition<Object> TRUE = new Condition<Object>(){

        @Override
        public boolean value(Object object) {
            return true;
        }
    };
    public static Condition<Object> FALSE = new Condition<Object>(){

        @Override
        public boolean value(Object object) {
            return false;
        }
    };

    @NotNull
    public static <T> Condition<T> alwaysTrue() {
        Condition<Object> condition = TRUE;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Conditions", "alwaysTrue"));
        }
        return condition;
    }

    public static <T> Condition<T> and(Condition<T> c1, Condition<T> c2) {
        return new And<T>(c1, c2);
    }

    private static class And<T>
    implements Condition<T> {
        private final Condition<? super T> t1;
        private final Condition<? super T> t2;

        public And(Condition<? super T> t1, Condition<? super T> t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        @Override
        public boolean value(T object) {
            return this.t1.value(object) && this.t2.value(object);
        }
    }
}

