/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.serializer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsSerializationUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage$DescriptorUtils$01ec8e24;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope$$TImpl;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializationUtil;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsSerializerExtension;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.serializer.ClassSerializationUtil;
import org.jetbrains.kotlin.utils.serializer.KotlinJavaScriptSerializer;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"V\u0006)Q2j\u001c;mS:T\u0015M^1TGJL\u0007\u000f^*fe&\fG.\u001b>fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0003vi&d7O\u0003\u0006tKJL\u0017\r\\5{KJT1!\u00118z\u0015\u0019a\u0014N\\5u})Yq-\u001a;GS2,g*Y7f\u0015=\u0019G.Y:t\t\u0016\u001c8M]5qi>\u0014(bD\"mCN\u001cH)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0005tKJL\u0017\r\\5{K*QQn\u001c3vY\u0016t\u0015-\\3\u000b!5|G-\u001e7f\t\u0016\u001c8M]5qi>\u0014(\u0002E'pIVdW\rR3tGJL\u0007\u000f^8s\u0015!iW\r^1GS2,'\u0002\u0002$jY\u0016T!![8\u000b\tUs\u0017\u000e\u001e\u0006\u0011g\u0016\u0014\u0018.\u00197ju\u0016\u0004\u0016mY6bO\u0016Ta!\\8ek2,'B\u00024r\u001d\u0006lWM\u0003\u0004Gc:\u000bW.\u001a\u0006\u0005]\u0006lWM\u0003\u0005xe&$XMR;o\u0015%1UO\\2uS>t'GC\u000bCsR,\u0017I\u001d:bs>+H\u000f];u'R\u0014X-Y71\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0002\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0011A!\u0001E\u0006\u000b\r!A\u0001C\u0003\r\u0001\u0015\u0019Aa\u0001\u0005\u0007\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u0011-\u0001bB\u0003\u0003\t\u0019Aa!\u0002\u0002\u0005\t!)Qa\u0001\u0003\u0005\u0011%a\u0001!\u0002\u0002\u0005\f!UQa\u0001\u0003\t\u0011)a\u0001!B\u0002\u0005\u0007!YA\u0002A\u0003\u0003\t\u0011A\u0011\"\u0002\u0002\u0005\u0011!QQA\u0001\u0003\u0002\u00117)1\u0001\"\u0006\t\u001b1\u0001Qa\u0001\u0003\u0004\u0011;a\u0001!B\u0002\u0005\u0011!yA\u0002A\u0003\u0003\t+AQ\"\u0002\u0002\u0005\u0007!uAa\u0001G\u00033\t)\u0011\u0001c\u0002.'\u0011\u0001\u0001\u0004BO\u0007\t\u0001AI!\u0004\u0002\u0006\u0003!%\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\"B)\u0004\u000b\u0011!\u0011\"\u0001E\u0007\u001b\u0005Aq!\f\u0014\u0005\u0007a=QT\u0002\u0003\u0001\u0011!i!!B\u0001\t\u000bA\u001b\u0001!(\u0004\u0005\u0001!EQBA\u0003\u0002\u0011\u001f\u00016\u0011AO\u0007\t\u0001A\u0019\"\u0004\u0002\u0006\u0003!E\u0001kA\u0001\"\u0005\u0015\t\u0001\"C)\u0004\u0013\u0011=\u0011\"\u0001\u0003\u0001\u001b\u0005Ai!D\u0001\t\u00145\t\u0001BC\u00173\t\u0001A:\"(\u0004\u0005\u0001!aQBA\u0003\u0002\u0011\u001f\u00016\u0001AO\u0007\t\u0001AI\"\u0004\u0002\u0006\u0003!Y\u0001k!\u0001\u001e&\u0011\u0001\u0001BD\u0007\u000f\u000b\u0005A9\"C\u0002\n\u0005\u0015\t\u0001\"B\u0005\u0004\u0013\t)\u0011\u0001\u0003\u0007\n\u0007%\u0011Q!\u0001\u0005\n!\u000e\t\u0011EA\u0003\u0002\u0011%\t6!\u0003C\f\u0013\u0005!\u0001!D\u0001\t\u00145\t\u0001\u0012D\u0007\u0002\u00115)4\"\u0002\u0006\u0005G\u0004A:!\t\u0002\u0006\u0003!\u0015\u0011kA\u0002\u0005\b%\tA\u0001\u0001"})
public final class KotlinJavaScriptSerializer {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavaScriptSerializer.class);
    }

    public final void serialize(@JetValueParameter(name="moduleName") @NotNull String moduleName, @JetValueParameter(name="moduleDescriptor") @NotNull ModuleDescriptor moduleDescriptor, @JetValueParameter(name="metaFile") @NotNull File metaFile) {
        Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkParameterIsNotNull(metaFile, "metaFile");
        HashMap contentMap = KotlinPackage.hashMapOf(new Pair[0]);
        Iterable iterable = DescriptorUtils.getPackagesFqNames(moduleDescriptor);
        for (Object t : iterable) {
            FqName fqName2;
            FqName fqName3 = fqName2 = (FqName)t;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            this.serializePackage(moduleDescriptor, fqName3, (Function2<? super String, ? super ByteArrayOutputStream, ? extends Unit>)new Function2<String, ByteArrayOutputStream, Unit>(this, moduleDescriptor, contentMap){
                final /* synthetic */ KotlinJavaScriptSerializer this$0;
                final /* synthetic */ ModuleDescriptor $moduleDescriptor$inlined;
                final /* synthetic */ HashMap $contentMap$inlined;

                public final void invoke(String fileName, ByteArrayOutputStream stream2) {
                    KotlinPackage.set(this.$contentMap$inlined, fileName, stream2.toByteArray());
                }
                {
                    this.this$0 = kotlinJavaScriptSerializer;
                    this.$moduleDescriptor$inlined = moduleDescriptor;
                    this.$contentMap$inlined = hashMap;
                }
            });
        }
        byte[] content = KotlinJavascriptSerializationUtil.INSTANCE$.contentMapToByteArray(contentMap);
        KotlinJavascriptMetadataUtils.INSTANCE$.writeMetadata(moduleName, content, metaFile);
    }

    public final void serializePackage(@JetValueParameter(name="module") @NotNull ModuleDescriptor module, @JetValueParameter(name="fqName") @NotNull FqName fqName2, @JetValueParameter(name="writeFun") @NotNull Function2<? super String, ? super ByteArrayOutputStream, ? extends Unit> writeFun) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(writeFun, "writeFun");
        PackageViewDescriptor packageViewDescriptor = module.getPackage(fqName2);
        if (packageViewDescriptor == null) {
            packageViewDescriptor = (PackageViewDescriptor)((Object)KotlinPackage.error("No package resolved in " + module));
        }
        PackageViewDescriptor packageView = packageViewDescriptor;
        Function1 skip2 = new Function1<DeclarationDescriptor, Boolean>(module){
            final /* synthetic */ ModuleDescriptor $module;

            public final boolean invoke(@JetValueParameter(name="it") @NotNull DeclarationDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return Intrinsics.areEqual(DescriptorUtils.getContainingModule(it), this.$module) ^ true;
            }
            {
                this.$module = moduleDescriptor;
            }
        };
        DescriptorSerializer serializer = DescriptorSerializer.createTopLevel(BuiltInsSerializerExtension.INSTANCE$);
        List classifierDescriptors = DescriptorSerializer.sort(JetScope$$TImpl.getDescriptors$default(packageView.getMemberScope(), DescriptorKindFilter.Companion.getCLASSIFIERS(), null, 2));
        Collection collection = classifierDescriptors;
        Intrinsics.checkExpressionValueIsNotNull(collection, "classifierDescriptors");
        DescriptorSerializer descriptorSerializer = serializer;
        Intrinsics.checkExpressionValueIsNotNull(descriptorSerializer, "serializer");
        ClassSerializationUtil.INSTANCE$.serializeClasses(collection, descriptorSerializer, new ClassSerializationUtil.Sink(this, writeFun){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ KotlinJavaScriptSerializer this$0;
            final /* synthetic */ Function2 $writeFun;

            static {
                $kotlinClass = Reflection.createKotlinClass(serializePackage.1.class);
            }

            public void writeClass(@JetValueParameter(name="classDescriptor") @NotNull ClassDescriptor classDescriptor, @JetValueParameter(name="classProto") @NotNull ProtoBuf.Class classProto) {
                Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(classProto, "classProto");
                ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
                classProto.writeTo(stream2);
                this.$writeFun.invoke(this.this$0.getFileName(classDescriptor), stream2);
            }
            {
                this.this$0 = $outer;
                this.$writeFun = $captured_local_variable$1;
            }
        }, skip2);
        ByteArrayOutputStream packageStream = new ByteArrayOutputStream();
        List<PackageFragmentDescriptor> fragments = module.getPackageFragmentProvider().getPackageFragments(fqName2);
        ProtoBuf.Package package_ = serializer.packageProto((Collection<PackageFragmentDescriptor>)fragments, skip2).build();
        if (package_ == null) {
            package_ = (ProtoBuf.Package)((Object)KotlinPackage.error("Package fragments not serialized: " + fragments));
        }
        ProtoBuf.Package packageProto = package_;
        packageProto.writeTo(packageStream);
        writeFun.invoke(BuiltInsSerializationUtil.INSTANCE$.getPackageFilePath(fqName2), packageStream);
        ByteArrayOutputStream nameStream = new ByteArrayOutputStream();
        StringTable strings2 = serializer.getStringTable();
        SerializationUtil.serializeStringTable(nameStream, strings2.serializeSimpleNames(), strings2.serializeQualifiedNames());
        writeFun.invoke(BuiltInsSerializationUtil.INSTANCE$.getStringTableFilePath(fqName2), nameStream);
    }

    @NotNull
    public final String getFileName(@JetValueParameter(name="classDescriptor") @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        return BuiltInsSerializationUtil.INSTANCE$.getClassMetadataPath(DescriptorUtilPackage$DescriptorUtils$01ec8e24.getClassId(classDescriptor));
    }
}

