/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.slicedMap.MapSupplier;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RemovableSlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.SlicedMapKey;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class SlicedMapImpl
implements MutableSlicedMap {
    private final Map<SlicedMapKey<?, ?>, Object> map;
    private final Multimap<WritableSlice<?, ?>, Object> collectiveSliceKeys = ArrayListMultimap.create();

    public static SlicedMapImpl create() {
        return new SlicedMapImpl(Maps.<SlicedMapKey<?, ?>, Object>newLinkedHashMap());
    }

    public static SlicedMapImpl create(Map<SlicedMapKey<?, ?>, Object> map) {
        return new SlicedMapImpl(map);
    }

    public static SlicedMapImpl create(MapSupplier mapSupplier) {
        return new SlicedMapImpl(mapSupplier.get());
    }

    protected SlicedMapImpl(Map<SlicedMapKey<?, ?>, Object> map) {
        this.map = map;
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        if (!slice.check(key, value)) {
            return;
        }
        SlicedMapKey slicedMapKey = slice.makeKey(key);
        RewritePolicy rewritePolicy = slice.getRewritePolicy();
        if (rewritePolicy.rewriteProcessingNeeded(key) && this.map.containsKey(slicedMapKey) && !rewritePolicy.processRewrite(slice, key, this.map.get(slicedMapKey), value)) {
            return;
        }
        if (slice.isCollective()) {
            this.collectiveSliceKeys.put(slice, key);
        }
        this.map.put(slicedMapKey, value);
        slice.afterPut(this, key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        Object value;
        SlicedMapKey<K, V> slicedMapKey = slice.makeKey(key);
        return (V)slice.computeValue(this, key, value, (value = this.map.get(slicedMapKey)) == null && !this.map.containsKey(slicedMapKey));
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        assert (slice.isCollective()) : "Keys are not collected for slice " + slice;
        return this.collectiveSliceKeys.get(slice);
    }

    @Override
    public <K, V> V remove(RemovableSlice<K, V> slice, K key) {
        return (V)this.map.remove(slice.makeKey(key));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<SlicedMapKey<?, ?>, ?>> iterator() {
        Iterator<Map.Entry<SlicedMapKey<?, ?>, ?>> iterator2 = this.map.entrySet().iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "iterator"));
        }
        return iterator2;
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "getSliceContents"));
        }
        ImmutableMap.Builder<?, Object> builder = ImmutableMap.builder();
        for (Map.Entry<SlicedMapKey<?, ?>, Object> entry : this.map.entrySet()) {
            if (entry.getKey().getSlice() != slice) continue;
            builder.put(entry.getKey().getKey(), entry.getValue());
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl", "getSliceContents"));
        }
        return immutableMap;
    }
}

