/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(abiVersion=22, kind=KotlinClass.Kind.CLASS, data={"2\u0006)Q2+\u001a8tK2,7o]\"p[B\f'/[:p]\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0003usB,7OC\u0006fqB\u0014Xm]:j_:\u001c(bA!os*\u00013\r[3dWN+gn]3mKN\u001c8i\\7qCJL7o\u001c8XSRDg*\u001e7m\u0015))\u0007\u0010\u001d:fgNLwN\u001c\u0006\u0014\u0015\u0016$()\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004aNL'\u0002\u00027fMRTQBS3u\u000bb\u0004(/Z:tS>t'\"\u0002:jO\"$(\"\u0002;sC\u000e,'\u0002\u0004\"j]\u0012Lgn\u001a+sC\u000e,'b\u0002:fg>dg/\u001a\u0006\bO\u0016$H+\u001f9f\u0015%1UO\\2uS>t\u0017GC\u0004KKR$\u0016\u0010]3\u000b\u001d\u001d,GOT;mY\u0006\u0014\u0017\u000e\\5us*iA)\u0019;b\r2|wOV1mk\u0016TQaY1mYNT!b]7beR\u001c\u0017m\u001d;t\u0015-qU\u000f\u001c7bE&d\u0017\u000e^=\u000b\tUs\u0017\u000e\u001eQ\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0007\u0011!\u0001\u0012\u0002\u0007\u0001\u000b\r!A\u0001\u0003\u0004\r\u0001\u0015\u0011A!\u0001\u0005\t\u000b\r!Y\u0001c\u0004\r\u0001\u0015\u0019Aa\u0001\u0005\n\u0019\u0001)1\u0001b\u0001\t\u00141\u0001QA\u0001C\u0006\u0011-)!\u0001b\u0004\t\u0018\u0015\u0019A\u0001\u0003E\u000b\u0019\u0001)1\u0001\u0002\u0005\t\u00191\u0001Qa\u0001\u0003\u0004\u00113a\u0001!\u0002\u0002\u0005\t!%QA\u0001\u0003\u0005\u0011\u0019)!\u0001b\u0003\t\u0010\u0015\u0011Aa\u0001\u0005\n\t\u0001\fARA\r\u0003\u000b\u0005A9!lj\u0001\t\u0003A:!(\u0004\u0005\u0001!!QBA\u0003\u0002\u0011\u0013\u00016\u0001AO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!)\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001RB\u0007\u0003\u000b\u0005AQ\u0001U\u0002\u0002;\u001b!\u0001\u0001C\u0004\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0004u}A\u0001\u0001E\t\u001b-)\u0011\u0001#\u0004\n\u0007%\u0011Q!\u0001\u0005\u0006\u0013\u0011I1!B\u0001\t\u000f1\u0005\u0001k\u0001\u0002\u001e\u001e\u0011\u0001\u0001BC\u0007\u000b\u000b\u0005Ai!C\u0002\n\u0005\u0015\t\u0001\u0012C\u0005\u0004\u0013\t)\u0011\u0001C\u0005Q\u0007\u000b\t#!B\u0001\t\u0014E\u001bq\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005A)\"D\u0001\t\u00165\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001c\u00066\u0001\u0001"})
public final class SenselessComparisonChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final SenselessComparisonChecker INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(SenselessComparisonChecker.class);
        new SenselessComparisonChecker();
    }

    @platformStatic
    public static final void checkSenselessComparisonWithNull(@JetValueParameter(name="expression") @NotNull JetBinaryExpression expression, @JetValueParameter(name="left") @NotNull JetExpression left, @JetValueParameter(name="right") @NotNull JetExpression right, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="getType") @NotNull Function1<? super JetExpression, ? extends JetType> getType, @JetValueParameter(name="getNullability") @NotNull Function1<? super DataFlowValue, ? extends Nullability> getNullability) {
        boolean bl;
        JetExpression jetExpression;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(left, "left");
        Intrinsics.checkParameterIsNotNull(right, "right");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(getType, "getType");
        Intrinsics.checkParameterIsNotNull(getNullability, "getNullability");
        if (JetPsiUtil.isNullConstant(left)) {
            jetExpression = right;
        } else if (JetPsiUtil.isNullConstant(right)) {
            jetExpression = left;
        } else {
            return;
        }
        JetExpression expr = jetExpression;
        JetType type2 = getType.invoke(expr);
        if (!(type2 == null) ? type2.isError() : true) {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        DataFlowValue value = DataFlowValueFactory.createDataFlowValue(expr, type2, trace.getBindingContext());
        boolean equality = !Intrinsics.areEqual(operationSign.getReferencedNameElementType(), JetTokens.EQEQ) ? Intrinsics.areEqual(operationSign.getReferencedNameElementType(), JetTokens.EQEQEQ) : true;
        DataFlowValue dataFlowValue = value;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "value");
        Nullability nullability = getNullability.invoke(dataFlowValue);
        if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL)) {
            bl = equality;
        } else if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NOT_NULL)) {
            bl = !equality;
        } else if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.IMPOSSIBLE)) {
            bl = false;
        } else {
            return;
        }
        boolean expressionIsAlways = bl;
        trace.report(Errors.SENSELESS_COMPARISON.on((JetBinaryExpression)((PsiElement)expression), expression, expressionIsAlways));
    }

    SenselessComparisonChecker() {
        INSTANCE$ = this;
    }
}

