/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionInRange;
import org.jetbrains.kotlin.psi.JetWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.WritableScopeImpl;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeInfo;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.DataFlowUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;

public class PatternMatchingTypingVisitor
extends ExpressionTypingVisitor {
    protected PatternMatchingTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @Override
    public JetTypeInfo visitIsExpression(@NotNull JetIsExpression expression, ExpressionTypingContext contextWithExpectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "visitIsExpression"));
        }
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression leftHandSide = expression.getLeftHandSide();
        JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(leftHandSide, (ExpressionTypingContext)context2.replaceScope(context2.scope));
        JetType knownType = typeInfo.getType();
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        if (expression.getTypeReference() != null) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(leftHandSide, knownType, context2.trace.getBindingContext());
            DataFlowInfo conditionInfo = this.checkTypeForIs(context2, knownType, expression.getTypeReference(), dataFlowValue).thenInfo;
            DataFlowInfo newDataFlowInfo = conditionInfo.and(dataFlowInfo);
            context2.trace.record(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression, newDataFlowInfo);
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getBooleanType(), (JetExpression)expression, (ResolutionContext)contextWithExpectedType, dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "visitWhenExpression"));
        }
        return this.visitWhenExpression(expression, context2, false);
    }

    public JetTypeInfo visitWhenExpression(JetWhenExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetType subjectType;
        DataFlowUtils.recordExpectedType(contextWithExpectedType.trace, expression, contextWithExpectedType.expectedType);
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetExpression subjectExpression = expression.getSubjectExpression();
        if (subjectExpression == null) {
            subjectType = ErrorUtils.createErrorType("Unknown type");
        } else {
            JetTypeInfo typeInfo = this.facade.safeGetTypeInfo(subjectExpression, context2);
            subjectType = typeInfo.getType();
            context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        }
        DataFlowValue subjectDataFlowValue = subjectExpression != null ? DataFlowValueFactory.createDataFlowValue(subjectExpression, subjectType, context2.trace.getBindingContext()) : DataFlowValue.NULL;
        HashSet<JetType> expressionTypes = Sets.newHashSet();
        DataFlowInfo commonDataFlowInfo = null;
        DataFlowInfo elseDataFlowInfo = context2.dataFlowInfo;
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            DataFlowInfos infosForCondition = this.getDataFlowInfosForEntryCondition(whenEntry, (ExpressionTypingContext)context2.replaceDataFlowInfo(elseDataFlowInfo), subjectExpression, subjectType, subjectDataFlowValue);
            elseDataFlowInfo = elseDataFlowInfo.and(infosForCondition.elseInfo);
            JetExpression bodyExpression = whenEntry.getExpression();
            if (bodyExpression == null) continue;
            WritableScopeImpl scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context2, "Scope extended in when entry");
            ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceScope(scopeToExtend)).replaceDataFlowInfo(infosForCondition.thenInfo)).replaceContextDependency(ContextDependency.INDEPENDENT);
            CoercionStrategy coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
            JetTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(bodyExpression), coercionStrategy, newContext);
            JetType type2 = typeInfo.getType();
            if (type2 != null) {
                expressionTypes.add(type2);
            }
            if (commonDataFlowInfo == null) {
                commonDataFlowInfo = typeInfo.getDataFlowInfo();
                continue;
            }
            commonDataFlowInfo = commonDataFlowInfo.or(typeInfo.getDataFlowInfo());
        }
        if (commonDataFlowInfo == null) {
            commonDataFlowInfo = context2.dataFlowInfo;
        }
        if (!expressionTypes.isEmpty()) {
            return DataFlowUtils.checkImplicitCast(CommonSupertypes.commonSupertype(expressionTypes), expression, contextWithExpectedType, isStatement, commonDataFlowInfo);
        }
        return JetTypeInfo.create(null, commonDataFlowInfo);
    }

    @NotNull
    private DataFlowInfos getDataFlowInfosForEntryCondition(@NotNull JetWhenEntry whenEntry, @NotNull ExpressionTypingContext context2, @Nullable JetExpression subjectExpression, @NotNull JetType subjectType, @NotNull DataFlowValue subjectDataFlowValue) {
        if (whenEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenEntry", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (subjectDataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectDataFlowValue", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        if (whenEntry.isElse()) {
            DataFlowInfos dataFlowInfos = new DataFlowInfos(context2.dataFlowInfo);
            if (dataFlowInfos == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
            }
            return dataFlowInfos;
        }
        DataFlowInfos infos = null;
        for (JetWhenCondition condition : whenEntry.getConditions()) {
            DataFlowInfos conditionInfos = this.checkWhenCondition(subjectExpression, subjectType, condition, context2, subjectDataFlowValue);
            infos = infos != null ? new DataFlowInfos(infos.thenInfo.or(conditionInfos.thenInfo), infos.elseInfo.and(conditionInfos.elseInfo)) : conditionInfos;
        }
        DataFlowInfos dataFlowInfos = infos != null ? infos : new DataFlowInfos(context2.dataFlowInfo);
        if (dataFlowInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "getDataFlowInfosForEntryCondition"));
        }
        return dataFlowInfos;
    }

    private DataFlowInfos checkWhenCondition(final @Nullable JetExpression subjectExpression, final JetType subjectType, JetWhenCondition condition, final ExpressionTypingContext context2, final DataFlowValue subjectDataFlowValue) {
        final Ref<DataFlowInfos> newDataFlowInfo = new Ref<DataFlowInfos>(PatternMatchingTypingVisitor.noChange(context2));
        condition.accept(new JetVisitorVoid(){

            @Override
            public void visitWhenConditionInRange(@NotNull JetWhenConditionInRange condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionInRange"));
                }
                JetExpression rangeExpression = condition.getRangeExpression();
                if (rangeExpression == null) {
                    return;
                }
                if (subjectExpression == null) {
                    context2.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                    DataFlowInfo dataFlowInfo = PatternMatchingTypingVisitor.this.facade.getTypeInfo(rangeExpression, context2).getDataFlowInfo();
                    newDataFlowInfo.set(new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                    return;
                }
                ValueArgument argumentForSubject = CallMaker.makeExternalValueArgument(subjectExpression);
                JetTypeInfo typeInfo = PatternMatchingTypingVisitor.this.facade.checkInExpression(condition, condition.getOperationReference(), argumentForSubject, rangeExpression, context2);
                DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
                newDataFlowInfo.set(new DataFlowInfos(dataFlowInfo, dataFlowInfo));
                if (!((Object)KotlinBuiltIns.getInstance().getBooleanType()).equals(typeInfo.getType())) {
                    context2.trace.report(Errors.TYPE_MISMATCH_IN_RANGE.on(condition));
                }
            }

            @Override
            public void visitWhenConditionIsPattern(@NotNull JetWhenConditionIsPattern condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionIsPattern"));
                }
                if (subjectExpression == null) {
                    context2.trace.report(Errors.EXPECTED_CONDITION.on(condition));
                }
                if (condition.getTypeReference() != null) {
                    DataFlowInfos result2 = PatternMatchingTypingVisitor.this.checkTypeForIs(context2, subjectType, condition.getTypeReference(), subjectDataFlowValue);
                    if (condition.isNegated()) {
                        newDataFlowInfo.set(new DataFlowInfos(result2.elseInfo, result2.thenInfo));
                    } else {
                        newDataFlowInfo.set(result2);
                    }
                }
            }

            @Override
            public void visitWhenConditionWithExpression(@NotNull JetWhenConditionWithExpression condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitWhenConditionWithExpression"));
                }
                JetExpression expression = condition.getExpression();
                if (expression != null) {
                    newDataFlowInfo.set(PatternMatchingTypingVisitor.this.checkTypeForExpressionCondition(context2, expression, subjectType, subjectExpression == null, subjectDataFlowValue));
                }
            }

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor$1", "visitJetElement"));
                }
                context2.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
            }
        });
        return newDataFlowInfo.get();
    }

    private DataFlowInfos checkTypeForExpressionCondition(ExpressionTypingContext context2, JetExpression expression, JetType subjectType, boolean conditionExpected, DataFlowValue subjectDataFlowValue) {
        if (expression == null) {
            return PatternMatchingTypingVisitor.noChange(context2);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(expression, context2);
        JetType type2 = typeInfo.getType();
        if (type2 == null) {
            return PatternMatchingTypingVisitor.noChange(context2);
        }
        context2 = (ExpressionTypingContext)context2.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (conditionExpected) {
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            if (JetTypeChecker.DEFAULT.equalTypes(booleanType, type2)) {
                DataFlowInfo ifInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression, true, context2);
                DataFlowInfo elseInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression, false, context2);
                return new DataFlowInfos(ifInfo, elseInfo);
            }
            context2.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(expression, type2));
            return PatternMatchingTypingVisitor.noChange(context2);
        }
        PatternMatchingTypingVisitor.checkTypeCompatibility(context2, type2, subjectType, expression);
        DataFlowValue expressionDataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, type2, context2.trace.getBindingContext());
        DataFlowInfos result2 = PatternMatchingTypingVisitor.noChange(context2);
        result2 = new DataFlowInfos(result2.thenInfo.equate(subjectDataFlowValue, expressionDataFlowValue), result2.elseInfo.disequate(subjectDataFlowValue, expressionDataFlowValue));
        return result2;
    }

    private DataFlowInfos checkTypeForIs(ExpressionTypingContext context2, JetType subjectType, JetTypeReference typeReferenceAfterIs, DataFlowValue subjectDataFlowValue) {
        if (typeReferenceAfterIs == null) {
            return PatternMatchingTypingVisitor.noChange(context2);
        }
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context2.scope, context2.trace, true, true);
        PossiblyBareType possiblyBareTarget = this.components.expressionTypingServices.getTypeResolver().resolvePossiblyBareType(typeResolutionContext, typeReferenceAfterIs);
        JetType targetType = TypeReconstructionUtil.reconstructBareType(typeReferenceAfterIs, possiblyBareTarget, subjectType, context2.trace);
        if (TypesPackage.isDynamic(targetType)) {
            context2.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(typeReferenceAfterIs));
        }
        if (!subjectType.isMarkedNullable() && targetType.isMarkedNullable()) {
            JetTypeElement element = typeReferenceAfterIs.getTypeElement();
            assert (element instanceof JetNullableType) : "element must be instance of " + JetNullableType.class.getName();
            JetNullableType nullableType = (JetNullableType)element;
            context2.trace.report(Errors.USELESS_NULLABLE_CHECK.on(nullableType));
        }
        PatternMatchingTypingVisitor.checkTypeCompatibility(context2, targetType, subjectType, typeReferenceAfterIs);
        if (CastDiagnosticsUtil.isCastErased(subjectType, targetType, JetTypeChecker.DEFAULT)) {
            context2.trace.report(Errors.CANNOT_CHECK_FOR_ERASED.on(typeReferenceAfterIs, targetType));
        }
        return new DataFlowInfos(context2.dataFlowInfo.establishSubtyping(subjectDataFlowValue, targetType), context2.dataFlowInfo);
    }

    private static DataFlowInfos noChange(ExpressionTypingContext context2) {
        return new DataFlowInfos(context2.dataFlowInfo, context2.dataFlowInfo);
    }

    private static void checkTypeCompatibility(@NotNull ExpressionTypingContext context2, @Nullable JetType type2, @NotNull JetType subjectType, @NotNull JetElement reportErrorOn) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (subjectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subjectType", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (reportErrorOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorOn", "org/jetbrains/kotlin/types/expressions/PatternMatchingTypingVisitor", "checkTypeCompatibility"));
        }
        if (type2 == null) {
            return;
        }
        if (TypeUtils.isIntersectionEmpty(type2, subjectType)) {
            context2.trace.report(Errors.INCOMPATIBLE_TYPES.on(reportErrorOn, type2, subjectType));
            return;
        }
        if (KotlinBuiltIns.isNullableNothing(type2) && !TypeUtils.isNullableType(subjectType)) {
            context2.trace.report(Errors.SENSELESS_NULL_IN_WHEN.on(reportErrorOn));
        }
    }

    private static class DataFlowInfos {
        private final DataFlowInfo thenInfo;
        private final DataFlowInfo elseInfo;

        private DataFlowInfos(DataFlowInfo thenInfo, DataFlowInfo elseInfo) {
            this.thenInfo = thenInfo;
            this.elseInfo = elseInfo;
        }

        private DataFlowInfos(DataFlowInfo info) {
            this(info, info);
        }
    }
}

