/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SubpackagesScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class JetModuleUtil {
    public static JetScope getSubpackagesOfRootScope(@NotNull ModuleDescriptor module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/JetModuleUtil", "getSubpackagesOfRootScope"));
        }
        return JetModuleUtil.getRootPackageScope(module, false);
    }

    public static JetScope getImportsResolutionScope(ModuleDescriptor module, boolean includeRootPackageClasses) {
        return JetModuleUtil.getRootPackageScope(module, includeRootPackageClasses);
    }

    private static JetScope getRootPackageScope(ModuleDescriptor module, boolean scopeIncludingMembers) {
        PackageViewDescriptor rootPackage = module.getPackage(FqName.ROOT);
        assert (rootPackage != null) : "Couldn't find root package for " + module;
        return scopeIncludingMembers ? rootPackage.getMemberScope() : new SubpackagesScope(rootPackage);
    }
}

