/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetBinaryExpression
extends JetExpressionImpl
implements JetOperationExpression {
    public JetBinaryExpression(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetBinaryExpression", "<init>"));
        }
        super(node2);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetBinaryExpression", "accept"));
        }
        return visitor2.visitBinaryExpression(this, data2);
    }

    @IfNotParsed
    @Nullable
    public JetExpression getLeft() {
        for (ASTNode node2 = this.getOperationReference().getNode().getTreePrev(); node2 != null; node2 = node2.getTreePrev()) {
            PsiElement psi = node2.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getRight() {
        for (ASTNode node2 = this.getOperationReference().getNode().getTreeNext(); node2 != null; node2 = node2.getTreeNext()) {
            PsiElement psi = node2.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public JetSimpleNameExpression getOperationReference() {
        JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
        if (jetSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetBinaryExpression", "getOperationReference"));
        }
        return jetSimpleNameExpression;
    }

    public IElementType getOperationToken() {
        return this.getOperationReference().getReferencedNameElementType();
    }
}

