/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.JetAnnotated;
import org.jetbrains.kotlin.psi.JetAnnotation;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetAnnotatedExpression
extends JetExpressionImpl
implements JetAnnotated {
    public JetAnnotatedExpression(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetAnnotatedExpression", "<init>"));
        }
        super(node2);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetAnnotatedExpression", "accept"));
        }
        return visitor2.visitAnnotatedExpression(this, data2);
    }

    @Nullable
    public JetExpression getBaseExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    @NotNull
    public List<JetAnnotation> getAnnotations() {
        List<JetAnnotation> list = this.findChildrenByType(JetNodeTypes.ANNOTATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetAnnotatedExpression", "getAnnotations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        List<JetAnnotationEntry> answer = null;
        for (JetAnnotation annotation2 : this.getAnnotations()) {
            if (answer == null) {
                answer = new ArrayList<JetAnnotationEntry>();
            }
            answer.addAll(annotation2.getEntries());
        }
        List<JetAnnotationEntry> list = answer != null ? answer : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetAnnotatedExpression", "getAnnotationEntries"));
        }
        return list;
    }
}

