/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsPackage;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class ManglingUtils {
    public static final Comparator<CallableMemberDescriptor> OVERLOADED_MEMBER_COMPARATOR = new OverloadedMemberComparator();

    private ManglingUtils() {
    }

    @NotNull
    public static String getMangledName(@NotNull PropertyDescriptor descriptor, @NotNull String suggestedName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        String string = ManglingUtils.getStableMangledName(suggestedName, DescriptorUtils.getFqName(descriptor).asString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        return string;
    }

    @NotNull
    public static String getSuggestedName(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
        }
        String suggestedName = descriptor.getName().asString();
        if (descriptor instanceof FunctionDescriptor || descriptor instanceof PropertyDescriptor && DescriptorUtils.isExtension((PropertyDescriptor)descriptor)) {
            suggestedName = ManglingUtils.getMangledName((CallableMemberDescriptor)descriptor);
        }
        String string = suggestedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSuggestedName"));
        }
        return string;
    }

    @NotNull
    private static String getMangledName(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        if (ManglingUtils.needsStableMangling(descriptor)) {
            String string = ManglingUtils.getStableMangledName(descriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
            }
            return string;
        }
        String string = ManglingUtils.getSimpleMangledName(descriptor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledName"));
        }
        return string;
    }

    private static boolean needsStableMangling(CallableMemberDescriptor descriptor) {
        if (DescriptorUtils.isOverride(descriptor)) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return descriptor.getVisibility().isPublicAPI();
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable()) {
                return true;
            }
            if (descriptor instanceof FunctionDescriptor && CodegenUtil.isEnumValueOfMethod((FunctionDescriptor)descriptor)) {
                return true;
            }
            if (!classDescriptor.getVisibility().isPublicAPI()) {
                return false;
            }
            return descriptor.getVisibility() == Visibilities.PUBLIC;
        }
        assert (containingDeclaration instanceof CallableMemberDescriptor) : "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor + ", containingDeclaration: " + containingDeclaration;
        return false;
    }

    @NotNull
    public static String getMangledMemberNameForExplicitDelegation(@NotNull String suggestedName, @NotNull FqNameUnsafe classFqName, @NotNull FqNameUnsafe typeFqName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        if (classFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFqName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        if (typeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeFqName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        String forCalculateId = classFqName.asString() + ":" + typeFqName.asString();
        String string = ManglingUtils.getStableMangledName(suggestedName, forCalculateId);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getMangledMemberNameForExplicitDelegation"));
        }
        return string;
    }

    @NotNull
    private static String getStableMangledName(@NotNull String suggestedName, String forCalculateId) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        int absHashCode = Math.abs(forCalculateId.hashCode());
        String suffix = absHashCode == 0 ? "" : "_" + Integer.toString(absHashCode, 36) + "$";
        String string = suggestedName + suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        return string;
    }

    @NotNull
    private static String getStableMangledName(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        String string = ManglingUtils.getStableMangledName(descriptor.getName().asString(), ManglingUtils.getArgumentTypesAsString(descriptor));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledName"));
        }
        return string;
    }

    @NotNull
    private static String getSimpleMangledName(final @NotNull CallableMemberDescriptor descriptor) {
        Collection<DeclarationDescriptor> declarations;
        List<CallableMemberDescriptor> overloadedFunctions;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSimpleMangledName"));
        }
        DeclarationDescriptor declaration = descriptor.getContainingDeclaration();
        JetScope jetScope = null;
        if (declaration instanceof PackageFragmentDescriptor) {
            jetScope = ((PackageFragmentDescriptor)declaration).getMemberScope();
        } else if (declaration instanceof ClassDescriptor) {
            jetScope = ((ClassDescriptor)declaration).getDefaultType().getMemberScope();
        }
        int counter = 0;
        if (jetScope != null && (overloadedFunctions = ContainerUtil.mapNotNull(declarations = jetScope.getDescriptors(DescriptorKindFilter.CALLABLES, JetScope.ALL_NAME_FILTER), new Function<DeclarationDescriptor, CallableMemberDescriptor>(){

            @Override
            public CallableMemberDescriptor fun(DeclarationDescriptor declarationDescriptor) {
                if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                    return null;
                }
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                String name = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(callableMemberDescriptor);
                if (name == null) {
                    if (ManglingUtils.needsStableMangling(callableMemberDescriptor) && !callableMemberDescriptor.getValueParameters().isEmpty()) {
                        return null;
                    }
                    name = callableMemberDescriptor.getName().asString();
                }
                return descriptor.getName().asString().equals(name) ? callableMemberDescriptor : null;
            }
        })).size() > 1) {
            Collections.sort(overloadedFunctions, OVERLOADED_MEMBER_COMPARATOR);
            counter = ContainerUtil.indexOfIdentity(overloadedFunctions, descriptor);
            assert (counter >= 0);
        }
        String name = descriptor.getName().asString();
        String string = counter == 0 ? name : name + '_' + counter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getSimpleMangledName"));
        }
        return string;
    }

    private static String getArgumentTypesAsString(CallableDescriptor descriptor) {
        StringBuilder argTypes = new StringBuilder();
        ReceiverParameterDescriptor receiverParameter = descriptor.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            argTypes.append(DescriptorUtilsPackage.getJetTypeFqName(receiverParameter.getType(), true)).append(".");
        }
        argTypes.append(StringUtil.join(descriptor.getValueParameters(), new Function<ValueParameterDescriptor, String>(){

            @Override
            public String fun(ValueParameterDescriptor descriptor) {
                return DescriptorUtilsPackage.getJetTypeFqName(descriptor.getType(), true);
            }
        }, ","));
        return argTypes.toString();
    }

    @NotNull
    public static String getStableMangledNameForDescriptor(@NotNull ClassDescriptor descriptor, @NotNull String functionName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledNameForDescriptor"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledNameForDescriptor"));
        }
        Collection<FunctionDescriptor> functions2 = descriptor.getDefaultType().getMemberScope().getFunctions(Name.identifier(functionName));
        assert (functions2.size() == 1) : "Can't select a single function: " + functionName + " in " + descriptor;
        String string = ManglingUtils.getSuggestedName(functions2.iterator().next());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils", "getStableMangledNameForDescriptor"));
        }
        return string;
    }

    private static class OverloadedMemberComparator
    implements Comparator<CallableMemberDescriptor> {
        private OverloadedMemberComparator() {
        }

        @Override
        public int compare(@NotNull CallableMemberDescriptor a, @NotNull CallableMemberDescriptor b) {
            int bArity;
            Integer result2;
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils$OverloadedMemberComparator", "compare"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/js/translate/utils/ManglingUtils$OverloadedMemberComparator", "compare"));
            }
            if (OverloadedMemberComparator.isNativeOrOverrideNative(a)) {
                if (!OverloadedMemberComparator.isNativeOrOverrideNative(b)) {
                    return -1;
                }
            } else if (OverloadedMemberComparator.isNativeOrOverrideNative(b)) {
                return 1;
            }
            if ((result2 = Visibilities.compare(b.getVisibility(), a.getVisibility())) != null && result2 != 0) {
                return result2;
            }
            int aArity = OverloadedMemberComparator.arity(a);
            if (aArity != (bArity = OverloadedMemberComparator.arity(b))) {
                return aArity - bArity;
            }
            String aArguments = ManglingUtils.getArgumentTypesAsString(a);
            String bArguments = ManglingUtils.getArgumentTypesAsString(b);
            assert (aArguments != bArguments);
            return aArguments.compareTo(bArguments);
        }

        private static int arity(CallableMemberDescriptor descriptor) {
            return descriptor.getValueParameters().size() + (descriptor.getExtensionReceiverParameter() == null ? 0 : 1);
        }

        private static boolean isNativeOrOverrideNative(CallableMemberDescriptor descriptor) {
            if (AnnotationsUtils.isNativeObject(descriptor)) {
                return true;
            }
            Set<CallableMemberDescriptor> declarations = DescriptorUtils.getAllOverriddenDeclarations(descriptor);
            for (CallableMemberDescriptor memberDescriptor : declarations) {
                if (!AnnotationsUtils.isNativeObject(memberDescriptor)) continue;
                return true;
            }
            return false;
        }
    }
}

