/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.CapturedParamOwner;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.org.objectweb.asm.Type;

public class ParametersBuilder {
    private final List<ParameterInfo> params = new ArrayList<ParameterInfo>();
    private final List<CapturedParamInfo> capturedParams = new ArrayList<CapturedParamInfo>();
    private int nextIndex = 0;
    private int nextCaptured = 0;

    @NotNull
    public static ParametersBuilder newBuilder() {
        ParametersBuilder parametersBuilder = new ParametersBuilder();
        if (parametersBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "newBuilder"));
        }
        return parametersBuilder;
    }

    @NotNull
    public ParameterInfo addThis(@NotNull Type type2, boolean skipped) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addThis"));
        }
        ParameterInfo info = new ParameterInfo(type2, skipped, this.nextIndex, -1);
        this.addParameter(info);
        ParameterInfo parameterInfo = info;
        if (parameterInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addThis"));
        }
        return parameterInfo;
    }

    @NotNull
    public ParameterInfo addNextParameter(@NotNull Type type2, boolean skipped, @Nullable StackValue remapValue) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addNextParameter"));
        }
        ParameterInfo parameterInfo = this.addParameter(new ParameterInfo(type2, skipped, this.nextIndex, remapValue));
        if (parameterInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addNextParameter"));
        }
        return parameterInfo;
    }

    @NotNull
    public CapturedParamInfo addCapturedParam(@NotNull CapturedParamInfo original, @NotNull String newFieldName) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (newFieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFieldName", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        CapturedParamInfo info = new CapturedParamInfo(original.desc, newFieldName, original.isSkipped, this.nextCaptured, original.getIndex());
        info.setLambda(original.getLambda());
        CapturedParamInfo capturedParamInfo = this.addCapturedParameter(info);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public CapturedParamInfo addCapturedParam(@NotNull CapturedParamDesc desc, @NotNull String newFieldName) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (newFieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFieldName", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        CapturedParamInfo info = new CapturedParamInfo(desc, newFieldName, false, this.nextCaptured, null);
        CapturedParamInfo capturedParamInfo = this.addCapturedParameter(info);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public CapturedParamInfo addCapturedParamCopy(@NotNull CapturedParamInfo copyFrom) {
        if (copyFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyFrom", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParamCopy"));
        }
        CapturedParamInfo info = copyFrom.newIndex(this.nextCaptured);
        CapturedParamInfo capturedParamInfo = this.addCapturedParameter(info);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParamCopy"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public CapturedParamInfo addCapturedParam(@NotNull CapturedParamOwner containingLambda, @NotNull String fieldName, @NotNull Type type2, boolean skipped, @Nullable ParameterInfo original) {
        if (containingLambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingLambda", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        CapturedParamInfo info = new CapturedParamInfo(CapturedParamDesc.createDesc(containingLambda, fieldName, type2), skipped, this.nextCaptured, original != null ? original.getIndex() : -1);
        if (original != null) {
            info.setLambda(original.getLambda());
        }
        CapturedParamInfo capturedParamInfo = this.addCapturedParameter(info);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        return capturedParamInfo;
    }

    @NotNull
    private ParameterInfo addParameter(ParameterInfo info) {
        this.params.add(info);
        this.nextIndex += info.getType().getSize();
        ParameterInfo parameterInfo = info;
        if (parameterInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addParameter"));
        }
        return parameterInfo;
    }

    @NotNull
    private CapturedParamInfo addCapturedParameter(CapturedParamInfo info) {
        this.capturedParams.add(info);
        this.nextCaptured += info.getType().getSize();
        CapturedParamInfo capturedParamInfo = info;
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "addCapturedParameter"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public List<ParameterInfo> listNotCaptured() {
        List<ParameterInfo> list = Collections.unmodifiableList(this.params);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "listNotCaptured"));
        }
        return list;
    }

    @NotNull
    public List<CapturedParamInfo> listCaptured() {
        List<CapturedParamInfo> list = Collections.unmodifiableList(this.capturedParams);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "listCaptured"));
        }
        return list;
    }

    @NotNull
    public List<ParameterInfo> listAllParams() {
        ArrayList<ParameterInfo> list = new ArrayList<ParameterInfo>(this.params);
        list.addAll(this.capturedParams);
        ArrayList<ParameterInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "listAllParams"));
        }
        return arrayList;
    }

    @NotNull
    private List<ParameterInfo> buildWithStubs() {
        List<ParameterInfo> list = Parameters.addStubs(this.listNotCaptured());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/ParametersBuilder", "buildWithStubs"));
        }
        return list;
    }

    private List<CapturedParamInfo> buildCapturedWithStubs() {
        return Parameters.shiftAndAddStubs(this.listCaptured(), this.nextIndex);
    }

    public Parameters buildParameters() {
        return new Parameters(this.buildWithStubs(), this.buildCapturedWithStubs());
    }

    public int getNextValueParameterIndex() {
        return this.nextIndex;
    }
}

