/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesPackage;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PlatformStaticGenerator;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.PackageFacadeContext;
import org.jetbrains.kotlin.codegen.optimization.OptimizationMethodVisitor;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.nativeDeclarations.NativeDeclarationsPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.JavaClassValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.DiagnosticsPackage;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.Approximation;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen {
    public final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final CodegenContext owner;
    private final ClassBuilder v;
    private final MemberCodegen<?> memberCodegen;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state, @NotNull MemberCodegen<?> memberCodegen) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        if (memberCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "<init>"));
        }
        this.owner = owner;
        this.v = v;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.memberCodegen = memberCodegen;
    }

    public void gen(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "gen"));
        }
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function);
        assert (functionDescriptor != null) : "No descriptor for function " + function.getText() + "\n" + "in " + function.getContainingFile().getVirtualFile();
        if (this.owner.getContextKind() != OwnerKind.TRAIT_IMPL || function.hasBody()) {
            this.generateMethod(DiagnosticsPackage.OtherOrigin(function, functionDescriptor), functionDescriptor, new FunctionGenerationStrategy.FunctionDefault(this.state, functionDescriptor, function));
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor), functionDescriptor, this.owner.getContextKind(), DefaultParameterValueLoader.DEFAULT, function);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor descriptor, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        this.generateMethod(origin, descriptor, this.owner.intoFunction(descriptor), strategy);
    }

    public void generateMethod(@NotNull JvmDeclarationOrigin origin, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethod"));
        }
        OwnerKind contextKind = methodContext.getContextKind();
        JvmMethodSignature jvmSignature = this.typeMapper.mapSignature(functionDescriptor, contextKind);
        Method asmMethod = jvmSignature.getAsmMethod();
        int flags = AsmUtil.getMethodAsmFlags(functionDescriptor, contextKind);
        boolean isNative = NativeDeclarationsPackage.hasNativeAnnotation(functionDescriptor);
        if (isNative && this.owner instanceof PackageContext && !(this.owner instanceof PackageFacadeContext)) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(origin, flags, asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.owner instanceof PackageFacadeContext) {
            Type ownerType = ((PackageFacadeContext)this.owner).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, functionDescriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, functionDescriptor, asmMethod);
        }
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(functionDescriptor, asmMethod.getReturnType());
        this.generateParameterAnnotations(functionDescriptor, mv, jvmSignature);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            FunctionCodegen.generateJetValueParameterAnnotations(mv, functionDescriptor, jvmSignature);
        }
        this.generateBridges(functionDescriptor);
        boolean staticInCompanionObject = AnnotationsPackage.isPlatformStaticInCompanionObject(functionDescriptor);
        if (staticInCompanionObject) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addAdditionalTask(new PlatformStaticGenerator(functionDescriptor, origin, this.state));
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES || AsmUtil.isAbstractMethod(functionDescriptor, contextKind)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext, this.typeMapper), new Label(), new Label(), contextKind);
            mv.visitEnd();
            return;
        }
        if (!isNative) {
            FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy, this.memberCodegen);
        } else if (staticInCompanionObject) {
            mv.visitCode();
            FunctionDescriptor staticFunctionDescriptor = PlatformStaticGenerator.createStaticFunctionDescriptor(functionDescriptor);
            JvmMethodSignature jvmMethodSignature = this.typeMapper.mapSignature(this.memberCodegen.getContext().accessibleFunctionDescriptor(staticFunctionDescriptor));
            Type owningType = this.typeMapper.mapClass((ClassifierDescriptor)staticFunctionDescriptor.getContainingDeclaration());
            FunctionCodegen.generateDelegateToMethodBody(false, mv, jvmMethodSignature.getAsmMethod(), owningType.getInternalName());
        }
        FunctionCodegen.endVisit(mv, null, origin.getElement());
        methodContext.recordSyntheticAccessorIfNeeded(functionDescriptor, this.bindingContext);
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> iterator2 = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            JvmMethodParameterSignature parameterSignature = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = parameterSignature.getKind();
            if (kind.isSkippedInGenericSignature()) {
                this.markEnumOrInnerConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind != JvmMethodParameterKind.VALUE) continue;
            ValueParameterDescriptor parameter = iterator2.next();
            this.v.getSerializationBindings().put(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, parameter, i);
            AnnotationCodegen.forParameter(i, mv, this.typeMapper).genAnnotations(parameter, parameterSignature.getAsmType());
        }
    }

    private static void generateJetValueParameterAnnotations(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull JvmMethodSignature jvmSignature) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> descriptors = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            boolean nullableType;
            String name;
            JvmMethodParameterKind kind = kotlinParameterTypes.get(i).getKind();
            if (kind.isSkippedInGenericSignature()) continue;
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor descriptor = descriptors.next();
                name = descriptor.getName().asString();
                nullableType = descriptor.getType().isMarkedNullable();
            } else {
                ReceiverParameterDescriptor receiver;
                String lowercaseKind = kind.name().toLowerCase();
                name = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
                nullableType = kind == JvmMethodParameterKind.RECEIVER ? (receiver = functionDescriptor.getExtensionReceiverParameter()) == null || receiver.getType().isMarkedNullable() : true;
            }
            AnnotationVisitor av = mv.visitParameterAnnotation(i, AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_VALUE_PARAMETER_ANNOTATION), true);
            if (av == null) continue;
            av.visit("name", name);
            if (nullableType) {
                av.visit("type", "?");
            }
            av.visitEnd();
        }
    }

    private void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i) {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context2, @NotNull JetTypeMapper typeMapper) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper.mapType(functionDescriptor);
        }
        if (dispatchReceiver != null) {
            return typeMapper.mapType(dispatchReceiver.getType());
        }
        if (DescriptorUtils.isFunctionLiteral(functionDescriptor) || DescriptorUtils.isLocalFunction(functionDescriptor) || DescriptorUtils.isFunctionExpression(functionDescriptor)) {
            return typeMapper.mapType(context2.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context2, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen) {
        Label methodEnd;
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateMethodBody"));
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        JetTypeMapper typeMapper = parentCodegen.typeMapper;
        if (context2.getParentContext() instanceof PackageFacadeContext) {
            FunctionCodegen.generatePackageDelegateMethodBody(mv, signature.getAsmMethod(), (PackageFacadeContext)context2.getParentContext());
            methodEnd = new Label();
        } else {
            FrameMap frameMap = FunctionCodegen.createFrameMap(parentCodegen.state, functionDescriptor, signature, AsmUtil.isStaticMethod(context2.getContextKind(), functionDescriptor));
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context2.setMethodStartLabel(methodEntry);
            if (!JetTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            methodEnd = new Label();
            context2.setMethodEndLabel(methodEnd);
            strategy.generateBody(mv, frameMap, signature, context2, parentCodegen);
        }
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context2, typeMapper);
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, context2.getContextKind());
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        boolean isStatic = AsmUtil.isStaticMethod(ownerKind, functionDescriptor);
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameters.next();
                parameterName = parameter.getName().asString();
            } else {
                String lowercaseKind = kind.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type2 = param.getAsmType();
            mv.visitLocalVariable(parameterName, type2.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type2.getSize();
        }
    }

    private static void generatePackageDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull PackageFacadeContext context2) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generatePackageDelegateMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generatePackageDelegateMethodBody"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generatePackageDelegateMethodBody"));
        }
        FunctionCodegen.generateDelegateToMethodBody(true, mv, asmMethod, context2.getDelegateToClassType().getInternalName());
    }

    private static void generateDelegateToMethodBody(boolean isStatic, @NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull String classToDelegateTo) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        if (classToDelegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToDelegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDelegateToMethodBody"));
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int k = isStatic ? 0 : 1;
        for (Type argType : argTypes) {
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(classToDelegateTo, asmMethod.getName(), asmMethod.getDescriptor(), false);
        iv.areturn(asmMethod.getReturnType());
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode != null ? "\nbytecode:\n" + bytecode : ""), t, method);
        }
    }

    private static String renderByteCodeIfAvailable(MethodVisitor mv) {
        String bytecode = null;
        if (mv instanceof OptimizationMethodVisitor) {
            mv = ((OptimizationMethodVisitor)mv).getTraceMethodVisitorIfPossible();
        }
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode = sw.toString();
        }
        return bytecode;
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridges"));
        }
        if (descriptor instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.TRAIT_IMPL) {
            return;
        }
        if (DescriptorUtils.isTrait(descriptor.getContainingDeclaration())) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor)) {
            return;
        }
        if (CallResolverUtil.isOrOverridesSynthesized(descriptor)) {
            return;
        }
        Set<Bridge<Method>> bridgesToGenerate = BridgesPackage.generateBridgesForFunctionDescriptor(descriptor, new Function1<FunctionDescriptor, Method>(){

            @Override
            public Method invoke(FunctionDescriptor descriptor) {
                return FunctionCodegen.this.typeMapper.mapSignature(descriptor).getAsmMethod();
            }
        });
        if (!bridgesToGenerate.isEmpty()) {
            PsiElement origin = descriptor.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? DescriptorToSourceUtils.getSourceFromDescriptor(descriptor) : null;
            for (Bridge<Method> bridge : bridgesToGenerate) {
                this.generateBridge(origin, descriptor, bridge.getFrom(), bridge.getTo());
            }
        }
    }

    private static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isMethodOfAny"));
        }
        String name = descriptor.getName().asString();
        List<ValueParameterDescriptor> parameters2 = descriptor.getValueParameters();
        if (parameters2.isEmpty()) {
            return name.equals("hashCode") || name.equals("toString");
        }
        if (parameters2.size() == 1 && name.equals("equals")) {
            ValueParameterDescriptor parameter = parameters2.get(0);
            return ((Object)parameter.getType()).equals(KotlinBuiltIns.getInstance().getNullableAnyType());
        }
        return false;
    }

    @NotNull
    public static String[] getThrownExceptions(@NotNull FunctionDescriptor function, final @NotNull JetTypeMapper mapper) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        AnnotationDescriptor annotation2 = function.getAnnotations().findAnnotation(new FqName("kotlin.throws"));
        if (annotation2 == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<CompileTimeConstant<?>> values = annotation2.getAllValueArguments().values();
        if (values.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        CompileTimeConstant<?> value = values.iterator().next();
        if (!(value instanceof ArrayValue)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value;
        List<String> strings2 = ContainerUtil.mapNotNull(arrayValue.getValue(), new Function<CompileTimeConstant<?>, String>(){

            @Override
            public String fun(CompileTimeConstant<?> constant) {
                if (constant instanceof JavaClassValue) {
                    JavaClassValue classValue = (JavaClassValue)constant;
                    ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                    return mapper.mapClass(classDescriptor).getInternalName();
                }
                return null;
            }
        });
        String[] stringArray = ArrayUtil.toStringArray(strings2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        return stringArray;
    }

    static void generateConstructorWithoutParametersIfNeeded(@NotNull GenerationState state, @NotNull CallableMethod method, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ClassBuilder classBuilder, @NotNull JetClassOrObject classOrObject) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (!FunctionCodegen.isEmptyConstructorNeeded(state.getBindingContext(), constructorDescriptor, classOrObject)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(constructorDescriptor);
        MethodVisitor mv = classBuilder.newMethod(DiagnosticsPackage.OtherOrigin(constructorDescriptor), flags, "<init>", "()V", null, FunctionCodegen.getThrownExceptions(constructorDescriptor, state.getTypeMapper()));
        if (state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        InstructionAdapter v = new InstructionAdapter(mv);
        mv.visitCode();
        Type methodOwner = method.getOwner();
        v.load(0, methodOwner);
        int mask = 0;
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            Type paramType = state.getTypeMapper().mapType(parameterDescriptor.getType());
            AsmUtil.pushDefaultValueOnStack(paramType, v);
            int i = parameterDescriptor.getIndex();
            if (i != 0 && i % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            mask |= 1 << i % 32;
        }
        masks.add(mask);
        Iterator<ValueParameterDescriptor> i$ = masks.iterator();
        while (i$.hasNext()) {
            int m = (Integer)((Object)i$.next());
            v.iconst(m);
        }
        v.aconst(null);
        String desc = JetTypeMapper.getDefaultDescriptor(method.getAsmMethod(), false);
        v.invokespecial(methodOwner.getInternalName(), "<init>", desc, false);
        v.areturn(Type.VOID_TYPE);
        FunctionCodegen.endVisit(mv, "default constructor for " + methodOwner.getInternalName(), classOrObject);
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable JetNamedFunction function) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        DeclarationDescriptor contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && ((ClassDescriptor)contextClass).getKind() == ClassKind.TRAIT) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor) | AsmUtil.getDeprecatedAccessFlag(functionDescriptor) | (functionDescriptor instanceof ConstructorDescriptor ? 0 : 8);
        Method defaultMethod = this.typeMapper.mapDefaultMethod(functionDescriptor, kind, owner);
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.Synthetic(function, functionDescriptor), flags, defaultMethod.getName(), defaultMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            if (this.owner instanceof PackageFacadeContext) {
                mv.visitCode();
                FunctionCodegen.generatePackageDelegateMethodBody(mv, defaultMethod, (PackageFacadeContext)this.owner);
                FunctionCodegen.endVisit(mv, "default method delegation", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            } else {
                mv.visitCode();
                FunctionCodegen.generateDefaultImplBody(owner, functionDescriptor, mv, loadStrategy, function, this.memberCodegen);
                FunctionCodegen.endVisit(mv, "default method", DescriptorToSourceUtils.getSourceFromDescriptor(functionDescriptor));
            }
        }
    }

    public static void generateDefaultImplBody(@NotNull MethodContext methodContext, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy, @Nullable JetNamedFunction function, @NotNull MemberCodegen<?> parentCodegen) {
        int capturedArgumentsCount;
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateDefaultImplBody"));
        }
        GenerationState state = parentCodegen.state;
        JvmMethodSignature signature = state.getTypeMapper().mapSignature(functionDescriptor, methodContext.getContextKind());
        boolean isStatic = AsmUtil.isStaticMethod(methodContext.getContextKind(), functionDescriptor);
        FrameMap frameMap = FunctionCodegen.createFrameMap(state, functionDescriptor, signature, isStatic);
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, state, parentCodegen);
        CallGenerator generator = codegen.getOrCreateCallGenerator(functionDescriptor, function);
        FunctionCodegen.loadExplicitArgumentsOnStack(AsmTypes.OBJECT_TYPE, isStatic, signature, generator);
        List<JvmMethodParameterSignature> mappedParameters = signature.getValueParameters();
        for (capturedArgumentsCount = 0; capturedArgumentsCount < mappedParameters.size() && mappedParameters.get(capturedArgumentsCount).getKind() != JvmMethodParameterKind.VALUE; ++capturedArgumentsCount) {
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        int maskIndex = 0;
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        for (int index2 = 0; index2 < valueParameters.size(); ++index2) {
            if (index2 % 32 == 0) {
                maskIndex = frameMap.enterTemp(Type.INT_TYPE);
            }
            ValueParameterDescriptor parameterDescriptor = valueParameters.get(index2);
            Type type2 = mappedParameters.get(capturedArgumentsCount + index2).getAsmType();
            int parameterIndex = frameMap.getIndex(parameterDescriptor);
            if (parameterDescriptor.declaresDefaultValue()) {
                iv.load(maskIndex, Type.INT_TYPE);
                iv.iconst(1 << index2 % 32);
                iv.and(Type.INT_TYPE);
                Label loadArg = new Label();
                iv.ifeq(loadArg);
                StackValue.local(parameterIndex, type2).store(loadStrategy.genValue(parameterDescriptor, codegen), iv);
                iv.mark(loadArg);
            }
            generator.putValueIfNeeded(parameterDescriptor, type2, StackValue.local(parameterIndex, type2));
        }
        CallableMethod method = functionDescriptor instanceof ConstructorDescriptor ? state.getTypeMapper().mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : state.getTypeMapper().mapToCallableMethod(functionDescriptor, false, methodContext);
        generator.genCallWithoutAssertions(method, codegen);
        iv.areturn(signature.getReturnType());
    }

    @NotNull
    private static FrameMap createFrameMap(@NotNull GenerationState state, @NotNull FunctionDescriptor function, @NotNull JvmMethodSignature signature, boolean isStatic) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        FrameMap frameMap = new FrameMap();
        if (!isStatic) {
            frameMap.enterTemp(AsmTypes.OBJECT_TYPE);
        }
        for (JvmMethodParameterSignature jvmMethodParameterSignature : signature.getValueParameters()) {
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.RECEIVER) {
                ReceiverParameterDescriptor receiverParameter = function.getExtensionReceiverParameter();
                if (receiverParameter == null) continue;
                frameMap.enter(receiverParameter, state.getTypeMapper().mapType(receiverParameter));
                continue;
            }
            if (jvmMethodParameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            frameMap.enterTemp(jvmMethodParameterSignature.getAsmType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : function.getValueParameters()) {
            frameMap.enter(valueParameterDescriptor, state.getTypeMapper().mapType(valueParameterDescriptor));
        }
        FrameMap frameMap2 = frameMap;
        if (frameMap2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/FunctionCodegen", "createFrameMap"));
        }
        return frameMap2;
    }

    private static void loadExplicitArgumentsOnStack(@NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature, @NotNull CallGenerator callGenerator) {
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (callGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callGenerator", "org/jetbrains/kotlin/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        int var = 0;
        if (!isStatic) {
            callGenerator.putValueIfNeeded(null, ownerType, StackValue.local(var, ownerType));
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type2 = parameterSignature.getAsmType();
            callGenerator.putValueIfNeeded(null, type2, StackValue.local(var, type2));
            var += type2.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private static boolean isEmptyConstructorNeeded(@NotNull BindingContext context2, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull JetClassOrObject classOrObject) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isEmptyConstructorNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isEmptyConstructorNeeded"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/codegen/FunctionCodegen", "isEmptyConstructorNeeded"));
        }
        ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
        if (classOrObject.isLocal()) {
            return false;
        }
        if (CodegenBinding.canHaveOuter(context2, classDescriptor)) {
            return false;
        }
        if (Visibilities.isPrivate(classDescriptor.getVisibility()) || Visibilities.isPrivate(constructorDescriptor.getVisibility())) {
            return false;
        }
        if (constructorDescriptor.getValueParameters().isEmpty()) {
            return false;
        }
        if (classOrObject instanceof JetClass && FunctionCodegen.hasSecondaryConstructorsWithNoParameters((JetClass)classOrObject)) {
            return false;
        }
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            if (parameterDescriptor.declaresDefaultValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSecondaryConstructorsWithNoParameters(@NotNull JetClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/FunctionCodegen", "hasSecondaryConstructorsWithNoParameters"));
        }
        for (JetSecondaryConstructor constructor2 : klass.getSecondaryConstructors()) {
            if (!constructor2.getValueParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull FunctionDescriptor descriptor, @NotNull Method bridge, @NotNull Method delegateTo) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/kotlin/codegen/FunctionCodegen", "generateBridge"));
        }
        int flags = 4161;
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.Bridge(descriptor, origin), flags, delegateTo.getName(), bridge.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        ImplementationBodyCodegen.markLineNumberForSyntheticFunction(this.owner.getThisDescriptor(), iv);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    public void genDelegate(@NotNull FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor, StackValue field) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        this.genDelegate(functionDescriptor, overriddenDescriptor.getOriginal(), (ClassDescriptor)overriddenDescriptor.getContainingDeclaration(), field);
    }

    public void genDelegate(final @NotNull FunctionDescriptor delegateFunction, final FunctionDescriptor delegatedTo, final ClassDescriptor toClass, final StackValue field) {
        if (delegateFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateFunction", "org/jetbrains/kotlin/codegen/FunctionCodegen", "genDelegate"));
        }
        this.generateMethod(DiagnosticsPackage.Delegation(DescriptorToSourceUtils.descriptorToDeclaration(delegatedTo), delegateFunction), delegateFunction, new FunctionGenerationStrategy(){

            @Override
            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                if (mv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (frameMap == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/FunctionCodegen$3", "generateBody"));
                }
                if (parentCodegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/FunctionCodegen$3", "generateBody"));
                }
                Method delegateToMethod = FunctionCodegen.this.typeMapper.mapSignature(delegatedTo).getAsmMethod();
                Method delegateMethod = FunctionCodegen.this.typeMapper.mapSignature(delegateFunction).getAsmMethod();
                Type[] argTypes = delegateMethod.getArgumentTypes();
                Type[] originalArgTypes = delegateToMethod.getArgumentTypes();
                InstructionAdapter iv = new InstructionAdapter(mv);
                iv.load(0, AsmTypes.OBJECT_TYPE);
                field.put(field.type, iv);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                    reg += argTypes[i].getSize();
                }
                String internalName = FunctionCodegen.this.typeMapper.mapType(toClass).getInternalName();
                if (toClass.getKind() == ClassKind.TRAIT) {
                    iv.invokeinterface(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                } else {
                    iv.invokevirtual(internalName, delegateToMethod.getName(), delegateToMethod.getDescriptor());
                }
                StackValue stackValue = AsmUtil.genNotNullAssertions(FunctionCodegen.this.state, StackValue.onStack(delegateToMethod.getReturnType()), TypesPackage.getApproximationTo(delegatedTo.getReturnType(), delegateFunction.getReturnType(), new Approximation.DataFlowExtras.OnlyMessage(delegatedTo.getName() + "(...)")));
                stackValue.put(delegateMethod.getReturnType(), iv);
                iv.areturn(delegateMethod.getReturnType());
            }
        });
    }
}

