/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.JetJavaMirrorMarker;
import org.jetbrains.kotlin.asJava.KotlinJavaFileStubProvider;
import org.jetbrains.kotlin.asJava.KotlinLightClass;
import org.jetbrains.kotlin.asJava.KotlinLightClassForAnonymousDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForPackage;
import org.jetbrains.kotlin.asJava.KotlinLightModifierList;
import org.jetbrains.kotlin.asJava.KotlinWrappingLightClass;
import org.jetbrains.kotlin.asJava.LightClassDataForKotlinClass;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.OutermostKotlinClassLightClassData;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.types.JetType;

public class KotlinLightClassForExplicitDeclaration
extends KotlinWrappingLightClass
implements JetJavaMirrorMarker {
    private static final Key<CachedValue<OutermostKotlinClassLightClassData>> JAVA_API_STUB = Key.create("JAVA_API_STUB");
    private final FqName classFqName;
    protected final JetClassOrObject classOrObject;
    private PsiClass delegate;
    private final NullableLazyValue<PsiElement> parent;
    @Nullable
    private PsiModifierList modifierList;
    private final NullableLazyValue<PsiTypeParameterList> typeParameterList;
    private final NullableLazyValue<PsiFile> _containingFile;

    @Nullable
    public static KotlinLightClassForExplicitDeclaration create(@NotNull PsiManager manager, @NotNull JetClassOrObject classOrObject) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "create"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "create"));
        }
        if (LightClassUtil.belongsToKotlinBuiltIns(classOrObject.getContainingJetFile())) {
            return null;
        }
        FqName fqName2 = KotlinLightClassForExplicitDeclaration.predictFqName(classOrObject);
        if (fqName2 == null) {
            return null;
        }
        if (classOrObject instanceof JetObjectDeclaration && ((JetObjectDeclaration)classOrObject).isObjectLiteral()) {
            return new KotlinLightClassForAnonymousDeclaration(manager, fqName2, classOrObject);
        }
        return new KotlinLightClassForExplicitDeclaration(manager, fqName2, classOrObject);
    }

    @Nullable
    private static FqName predictFqName(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "predictFqName"));
        }
        if (classOrObject.isLocal()) {
            LightClassDataForKotlinClass data2 = KotlinLightClassForExplicitDeclaration.getLightClassDataExactly(classOrObject);
            return data2 == null ? null : data2.getJvmQualifiedName();
        }
        String internalName = PsiCodegenPredictor.getPredefinedJvmInternalName(classOrObject);
        return internalName == null ? null : JvmClassName.byInternalName(internalName).getFqNameForClassNameWithoutDollars();
    }

    KotlinLightClassForExplicitDeclaration(@NotNull PsiManager manager, @NotNull FqName name, @NotNull JetClassOrObject classOrObject) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "<init>"));
        }
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "<init>"));
        }
        super(manager);
        this.parent = new NullableLazyValue<PsiElement>(){

            @Override
            @Nullable
            protected PsiElement compute() {
                if (KotlinLightClassForExplicitDeclaration.this.classOrObject.isLocal()) {
                    PsiElement declaration = JetPsiUtil.getTopmostParentOfTypes(KotlinLightClassForExplicitDeclaration.this.classOrObject, JetNamedFunction.class, JetProperty.class, JetClassInitializer.class, JetParameter.class);
                    if (declaration instanceof JetParameter) {
                        declaration = PsiTreeUtil.getParentOfType(declaration, JetNamedDeclaration.class);
                    }
                    if (declaration instanceof JetNamedFunction) {
                        JetNamedFunction function = (JetNamedFunction)declaration;
                        return this.getParentByPsiMethod(LightClassUtil.getLightClassMethod(function), function.getName(), false);
                    }
                    if (declaration instanceof JetProperty) {
                        JetProperty property2 = (JetProperty)declaration;
                        return this.getParentByPsiMethod(LightClassUtil.getLightClassPropertyMethods(property2).getGetter(), property2.getName(), true);
                    }
                    if (declaration instanceof JetClassInitializer) {
                        PsiElement parent = declaration.getParent();
                        PsiElement grandparent = parent.getParent();
                        if (parent instanceof JetClassBody && grandparent instanceof JetClassOrObject) {
                            return LightClassUtil.getPsiClass((JetClassOrObject)grandparent);
                        }
                    }
                    if (declaration instanceof JetClass) {
                        return LightClassUtil.getPsiClass((JetClass)declaration);
                    }
                }
                return KotlinLightClassForExplicitDeclaration.this.classOrObject.getParent() == KotlinLightClassForExplicitDeclaration.this.classOrObject.getContainingFile() ? KotlinLightClassForExplicitDeclaration.this.getContainingFile() : KotlinLightClassForExplicitDeclaration.this.getContainingClass();
            }

            private PsiElement getParentByPsiMethod(PsiMethod method, final String name, boolean forceMethodWrapping) {
                if (method == null || name == null) {
                    return null;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return null;
                }
                final String currentFileName = KotlinLightClassForExplicitDeclaration.this.classOrObject.getContainingFile().getName();
                boolean createWrapper = forceMethodWrapping;
                if (containingClass instanceof KotlinLightClassForPackage) {
                    containingClass = new LightClass(containingClass, JetLanguage.INSTANCE){

                        @Override
                        @Nullable
                        public String getName() {
                            return currentFileName;
                        }
                    };
                    createWrapper = true;
                }
                if (createWrapper) {
                    return new LightMethod(KotlinLightClassForExplicitDeclaration.this.myManager, method, containingClass, JetLanguage.INSTANCE){

                        @Override
                        public PsiElement getParent() {
                            return this.getContainingClass();
                        }

                        @Override
                        @NotNull
                        public String getName() {
                            String string = name;
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration$1$2", "getName"));
                            }
                            return string;
                        }
                    };
                }
                return method;
            }
        };
        this.typeParameterList = new NullableLazyValue<PsiTypeParameterList>(){

            @Override
            @Nullable
            protected PsiTypeParameterList compute() {
                return LightClassUtil.buildLightTypeParameterList(KotlinLightClassForExplicitDeclaration.this, KotlinLightClassForExplicitDeclaration.this.classOrObject);
            }
        };
        this._containingFile = new NullableLazyValue<PsiFile>(){

            @Override
            @Nullable
            protected PsiFile compute() {
                VirtualFile virtualFile = KotlinLightClassForExplicitDeclaration.this.classOrObject.getContainingFile().getVirtualFile();
                assert (virtualFile != null) : "No virtual file for " + KotlinLightClassForExplicitDeclaration.this.classOrObject.getText();
                return new ClsFileImpl((FileViewProvider)new ClassFileViewProvider(KotlinLightClassForExplicitDeclaration.this.getManager(), virtualFile)){

                    @Override
                    @NotNull
                    public String getPackageName() {
                        String string = KotlinLightClassForExplicitDeclaration.this.classOrObject.getContainingJetFile().getPackageFqName().asString();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration$3$1", "getPackageName"));
                        }
                        return string;
                    }

                    @Override
                    @NotNull
                    public PsiClassHolderFileStub getStub() {
                        PsiJavaFileStub psiJavaFileStub = KotlinLightClassForExplicitDeclaration.this.getJavaFileStub();
                        if (psiJavaFileStub == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration$3$1", "getStub"));
                        }
                        return psiJavaFileStub;
                    }

                    @Override
                    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration$3$1", "processDeclarations"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration$3$1", "processDeclarations"));
                        }
                        if (place == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration$3$1", "processDeclarations"));
                        }
                        if (!super.processDeclarations(processor, state, lastParent, place)) {
                            return false;
                        }
                        String packageName = this.getPackageName();
                        if (!packageName.isEmpty()) {
                            return true;
                        }
                        PsiPackage aPackage = JavaPsiFacade.getInstance(KotlinLightClassForExplicitDeclaration.this.myManager.getProject()).findPackage(packageName);
                        return aPackage == null || aPackage.processDeclarations(processor, state, null, place);
                    }
                };
            }
        };
        this.classFqName = name;
        this.classOrObject = classOrObject;
    }

    @Override
    @NotNull
    public JetClassOrObject getOrigin() {
        JetClassOrObject jetClassOrObject = this.classOrObject;
        if (jetClassOrObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getOrigin"));
        }
        return jetClassOrObject;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName2 = this.classFqName;
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getFqName"));
        }
        return fqName2;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        KotlinLightClassForExplicitDeclaration kotlinLightClassForExplicitDeclaration = new KotlinLightClassForExplicitDeclaration(this.getManager(), this.classFqName, (JetClassOrObject)this.classOrObject.copy());
        if (kotlinLightClassForExplicitDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "copy"));
        }
        return kotlinLightClassForExplicitDeclaration;
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        if (this.delegate == null) {
            PsiJavaFileStub javaFileStub = this.getJavaFileStub();
            PsiClass psiClass = LightClassUtil.findClass(this.classFqName, javaFileStub);
            if (psiClass == null) {
                JetClassOrObject outermostClassOrObject = KotlinLightClassForExplicitDeclaration.getOutermostClassOrObject(this.classOrObject);
                throw new IllegalStateException("Class was not found " + this.classFqName + "\n" + "in " + outermostClassOrObject.getContainingFile().getText() + "\n" + "stub: \n" + ((PsiJavaFile)javaFileStub.getPsi()).getText());
            }
            this.delegate = psiClass;
        }
        PsiClass psiClass = this.delegate;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getDelegate"));
        }
        return psiClass;
    }

    @NotNull
    private PsiJavaFileStub getJavaFileStub() {
        PsiJavaFileStub psiJavaFileStub = this.getLightClassData().getJavaFileStub();
        if (psiJavaFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getJavaFileStub"));
        }
        return psiJavaFileStub;
    }

    @Nullable
    protected final ClassDescriptor getDescriptor() {
        LightClassDataForKotlinClass data2 = KotlinLightClassForExplicitDeclaration.getLightClassDataExactly(this.classOrObject);
        return data2 != null ? data2.getDescriptor() : null;
    }

    @NotNull
    private OutermostKotlinClassLightClassData getLightClassData() {
        OutermostKotlinClassLightClassData outermostKotlinClassLightClassData = KotlinLightClassForExplicitDeclaration.getLightClassData(this.classOrObject);
        if (outermostKotlinClassLightClassData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getLightClassData"));
        }
        return outermostKotlinClassLightClassData;
    }

    @NotNull
    public static OutermostKotlinClassLightClassData getLightClassData(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getLightClassData"));
        }
        JetClassOrObject outermostClassOrObject = KotlinLightClassForExplicitDeclaration.getOutermostClassOrObject(classOrObject);
        OutermostKotlinClassLightClassData outermostKotlinClassLightClassData = CachedValuesManager.getManager(classOrObject.getProject()).getCachedValue(outermostClassOrObject, JAVA_API_STUB, KotlinJavaFileStubProvider.createForDeclaredClass(outermostClassOrObject), false);
        if (outermostKotlinClassLightClassData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getLightClassData"));
        }
        return outermostKotlinClassLightClassData;
    }

    @Nullable
    private static LightClassDataForKotlinClass getLightClassDataExactly(JetClassOrObject classOrObject) {
        OutermostKotlinClassLightClassData data2 = KotlinLightClassForExplicitDeclaration.getLightClassData(classOrObject);
        return data2.getClassOrObject().equals(classOrObject) ? data2 : (LightClassDataForKotlinClass)data2.getAllInnerClasses().get(classOrObject);
    }

    @NotNull
    private static JetClassOrObject getOutermostClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getOutermostClassOrObject"));
        }
        JetClassOrObject outermostClass = JetPsiUtil.getOutermostClassOrObject(classOrObject);
        if (outermostClass == null) {
            throw new IllegalStateException("Attempt to build a light class for a local class: " + classOrObject.getText());
        }
        JetClassOrObject jetClassOrObject = outermostClass;
        if (jetClassOrObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getOutermostClassOrObject"));
        }
        return jetClassOrObject;
    }

    @Override
    public PsiFile getContainingFile() {
        return this._containingFile.getValue();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        JetClassOrObject jetClassOrObject = this.classOrObject;
        if (jetClassOrObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getNavigationElement"));
        }
        return jetClassOrObject;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof PsiClass && Comparing.equal(((PsiClass)another).getQualifiedName(), this.getQualifiedName());
    }

    @Override
    public Icon getElementIcon(int flags) {
        throw new UnsupportedOperationException("This should be done byt JetIconProvider");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KotlinLightClassForExplicitDeclaration aClass = (KotlinLightClassForExplicitDeclaration)o;
        return this.classFqName.equals(aClass.classFqName);
    }

    public int hashCode() {
        return this.classFqName.hashCode();
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        if (this.classOrObject.getParent() == this.classOrObject.getContainingFile()) {
            return null;
        }
        return super.getContainingClass();
    }

    @Override
    @Nullable
    public PsiElement getParent() {
        return this.parent.getValue();
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return this.typeParameterList.getValue();
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameterList typeParameterList = this.getTypeParameterList();
        PsiTypeParameter[] psiTypeParameterArray = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    @Override
    @Nullable
    public String getName() {
        return this.classFqName.shortName().asString();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.classFqName.asString();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        if (this.modifierList == null) {
            this.modifierList = new KotlinLightModifierList(this.getManager(), this.computeModifiers()){

                @Override
                public PsiAnnotationOwner getDelegate() {
                    return KotlinLightClassForExplicitDeclaration.this.getDelegate().getModifierList();
                }
            };
        }
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getModifierList"));
        }
        return psiModifierList;
    }

    @NotNull
    private String[] computeModifiers() {
        HashSet<String> psiModifiers = Sets.newHashSet();
        ArrayList<Pair> jetTokenToPsiModifier = Lists.newArrayList(Pair.create(JetTokens.PUBLIC_KEYWORD, "public"), Pair.create(JetTokens.INTERNAL_KEYWORD, "public"), Pair.create(JetTokens.PROTECTED_KEYWORD, "protected"), Pair.create(JetTokens.FINAL_KEYWORD, "final"));
        for (Pair tokenAndModifier : jetTokenToPsiModifier) {
            if (!this.classOrObject.hasModifier((JetModifierKeywordToken)tokenAndModifier.first)) continue;
            psiModifiers.add((String)tokenAndModifier.second);
        }
        if (this.classOrObject.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            psiModifiers.add(this.classOrObject.isTopLevel() ? "public" : "private");
        }
        if (!psiModifiers.contains("private") && !psiModifiers.contains("protected")) {
            psiModifiers.add("public");
        }
        if (this.isAbstract(this.classOrObject)) {
            psiModifiers.add("abstract");
        } else if (!(this.classOrObject.hasModifier(JetTokens.OPEN_KEYWORD) || this.classOrObject instanceof JetClass && ((JetClass)this.classOrObject).isEnum())) {
            psiModifiers.add("final");
        }
        if (!this.classOrObject.isTopLevel() && !this.classOrObject.hasModifier(JetTokens.INNER_KEYWORD)) {
            psiModifiers.add("static");
        }
        String[] stringArray = ArrayUtil.toStringArray(psiModifiers);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "computeModifiers"));
        }
        return stringArray;
    }

    private boolean isAbstract(@NotNull JetClassOrObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "isAbstract"));
        }
        return object.hasModifier(JetTokens.ABSTRACT_KEYWORD) || this.isInterface();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public boolean isDeprecated() {
        JetModifierList jetModifierList = this.classOrObject.getModifierList();
        if (jetModifierList == null) {
            return false;
        }
        ClassDescriptor deprecatedAnnotation = KotlinBuiltIns.getInstance().getDeprecatedAnnotation();
        String deprecatedName = deprecatedAnnotation.getName().asString();
        FqNameUnsafe deprecatedFqName = DescriptorUtils.getFqName(deprecatedAnnotation);
        for (JetAnnotationEntry annotationEntry : jetModifierList.getAnnotationEntries()) {
            FqName fqName2;
            JetTypeElement typeElement;
            JetTypeReference typeReference = annotationEntry.getTypeReference();
            if (typeReference == null || !((typeElement = typeReference.getTypeElement()) instanceof JetUserType) || (fqName2 = JetPsiUtil.toQualifiedName((JetUserType)typeElement)) == null) continue;
            if (deprecatedFqName.equals(fqName2.toUnsafe())) {
                return true;
            }
            if (!deprecatedName.equals(fqName2.asString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInterface() {
        if (!(this.classOrObject instanceof JetClass)) {
            return false;
        }
        JetClass jetClass = (JetClass)this.classOrObject;
        return jetClass.isTrait() || jetClass.isAnnotation();
    }

    @Override
    public boolean isAnnotationType() {
        return this.classOrObject instanceof JetClass && ((JetClass)this.classOrObject).isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.classOrObject instanceof JetClass && ((JetClass)this.classOrObject).isEnum();
    }

    @Override
    public boolean hasTypeParameters() {
        return this.classOrObject instanceof JetClass && !((JetClass)this.classOrObject).getTypeParameters().isEmpty();
    }

    @Override
    public boolean isValid() {
        return this.classOrObject.isValid();
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "isInheritor"));
        }
        if (baseClass instanceof KotlinLightClassForExplicitDeclaration || this.isInterface() && !baseClass.isInterface()) {
            ClassDescriptor baseDescriptor;
            String qualifiedName = baseClass instanceof KotlinLightClassForExplicitDeclaration ? ((baseDescriptor = ((KotlinLightClassForExplicitDeclaration)baseClass).getDescriptor()) != null ? DescriptorUtils.getFqName(baseDescriptor).asString() : null) : baseClass.getQualifiedName();
            ClassDescriptor thisDescriptor = this.getDescriptor();
            return qualifiedName != null && thisDescriptor != null && KotlinLightClassForExplicitDeclaration.checkSuperTypeByFQName(thisDescriptor, qualifiedName, checkDeep);
        }
        return super.isInheritor(baseClass, checkDeep);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "setName"));
        }
        this.getOrigin().setName(name);
        return this;
    }

    @Override
    public String toString() {
        try {
            return KotlinLightClass.class.getSimpleName() + ":" + this.getQualifiedName();
        }
        catch (Throwable e) {
            return KotlinLightClass.class.getSimpleName() + ":" + e.toString();
        }
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiClass> list = KotlinPackage.filterNotNull(KotlinPackage.map(this.getDelegate().getInnerClasses(), new Function1<PsiClass, PsiClass>(){

            @Override
            public PsiClass invoke(PsiClass aClass) {
                JetClassOrObject declaration = (JetClassOrObject)ClsWrapperStubPsiFactory.getOriginalDeclaration(aClass);
                return declaration != null ? KotlinLightClassForExplicitDeclaration.create(KotlinLightClassForExplicitDeclaration.this.myManager, declaration) : null;
            }
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getOwnInnerClasses"));
        }
        return list;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = this.getOrigin().getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "getUseScope"));
        }
        return searchScope;
    }

    private static boolean checkSuperTypeByFQName(@NotNull ClassDescriptor classDescriptor, @NotNull String qualifiedName, Boolean deep) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "checkSuperTypeByFQName"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/asJava/KotlinLightClassForExplicitDeclaration", "checkSuperTypeByFQName"));
        }
        if ("java.lang.Object".equals(qualifiedName)) {
            return true;
        }
        if (qualifiedName.equals(DescriptorUtils.getFqName(classDescriptor).asString())) {
            return true;
        }
        for (JetType superType : classDescriptor.getTypeConstructor().getSupertypes()) {
            ClassifierDescriptor superDescriptor = superType.getConstructor().getDeclarationDescriptor();
            if (!(superDescriptor instanceof ClassDescriptor)) continue;
            if (qualifiedName.equals(DescriptorUtils.getFqName(superDescriptor).asString())) {
                return true;
            }
            if (!deep.booleanValue() || !KotlinLightClassForExplicitDeclaration.checkSuperTypeByFQName((ClassDescriptor)superDescriptor, qualifiedName, true)) continue;
            return true;
        }
        return false;
    }
}

