/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.openapi.util.Couple;
import com.intellij.util.graph.Graph;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DFSTBuilder<Node> {
    private final Graph<Node> myGraph;
    private final Map<Node, Integer> myNodeToNNumber;
    private Map<Node, Integer> myNodeToTNumber;
    private final Node[] myInvN;
    private Couple<Node> myBackEdge = null;
    private Comparator<Node> myComparator = null;
    private boolean myNBuilt = false;
    private boolean myTBuilt = false;
    private TIntArrayList mySCCs = null;
    private Node[] myInvT;

    public DFSTBuilder(Graph<Node> graph) {
        this.myGraph = graph;
        this.myNodeToNNumber = new LinkedHashMap<Node, Integer>(this.myGraph.getNodes().size() * 2, 0.5f);
        this.myInvN = new Object[this.myGraph.getNodes().size()];
    }

    public void buildDFST() {
        if (this.myNBuilt) {
            return;
        }
        Collection<Node> nodes = this.myGraph.getNodes();
        int indexN = nodes.size();
        LinkedHashSet processed = new LinkedHashSet();
        for (Node node2 : nodes) {
            if (this.myGraph.getIn(node2).hasNext()) continue;
            indexN = this.traverseSubGraph(node2, indexN, processed);
        }
        for (Node node2 : nodes) {
            indexN = this.traverseSubGraph(node2, indexN, processed);
        }
        this.myNBuilt = true;
    }

    public Comparator<Node> comparator() {
        if (this.myComparator == null) {
            Map<Node, Integer> map;
            this.buildDFST();
            if (this.isAcyclic()) {
                map = this.myNodeToNNumber;
            } else {
                this.build_T();
                map = this.myNodeToTNumber;
            }
            this.myComparator = new Comparator<Node>(){

                @Override
                public int compare(Node t, Node t1) {
                    return ((Integer)map.get(t)).compareTo((Integer)map.get(t1));
                }
            };
        }
        return this.myComparator;
    }

    private int traverseSubGraph(Node node2, int nNumber, Set<Node> processed) {
        if (!processed.contains(node2)) {
            processed.add(node2);
            Iterator<Node> it = this.myGraph.getOut(node2);
            while (it.hasNext()) {
                nNumber = this.traverseSubGraph(it.next(), nNumber, processed);
            }
            this.myNodeToNNumber.put(node2, --nNumber);
            this.myInvN[nNumber] = node2;
            if (this.myBackEdge == null) {
                it = this.myGraph.getIn(node2);
                while (it.hasNext()) {
                    Node prev = it.next();
                    Integer prevNumber = this.myNodeToNNumber.get(prev);
                    if (prevNumber == null || prevNumber <= nNumber) continue;
                    this.myBackEdge = Couple.of(node2, prev);
                    break;
                }
            }
        }
        return nNumber;
    }

    private Set<Node> region(Node v) {
        LinkedList<Node> frontier = new LinkedList<Node>();
        frontier.addFirst(v);
        LinkedHashSet result2 = new LinkedHashSet();
        int number = this.myNodeToNNumber.get(v);
        while (!frontier.isEmpty()) {
            Object curr = frontier.removeFirst();
            result2.add(curr);
            Iterator<Node> it = this.myGraph.getIn(curr);
            while (it.hasNext()) {
                Node w = it.next();
                if (this.myNodeToNNumber.get(w) <= number || result2.contains(w)) continue;
                frontier.add(w);
            }
        }
        return result2;
    }

    private void build_T() {
        if (this.myTBuilt) {
            return;
        }
        this.myInvT = new Object[this.myGraph.getNodes().size()];
        this.mySCCs = new TIntArrayList();
        int size = this.myGraph.getNodes().size();
        this.myNodeToTNumber = new LinkedHashMap<Node, Integer>(size * 2, 0.5f);
        int currT = 0;
        for (int i = 0; i < size; ++i) {
            Node v = this.myInvN[i];
            if (this.myNodeToTNumber.containsKey(v)) continue;
            Set<Node> region = this.region(v);
            this.mySCCs.add(region.size());
            this.myNodeToTNumber.put(v, currT);
            this.myInvT[currT++] = v;
            for (Node w : region) {
                if (w == v) continue;
                this.myNodeToTNumber.put(w, currT);
                this.myInvT[currT++] = w;
            }
        }
        this.myTBuilt = true;
    }

    public Couple<Node> getCircularDependency() {
        this.buildDFST();
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    public Node getNodeByTNumber(int n) {
        return this.myInvT[n];
    }

    public TIntArrayList getSCCs() {
        if (!this.myNBuilt) {
            this.buildDFST();
        }
        if (!this.myTBuilt) {
            this.build_T();
        }
        return this.mySCCs;
    }
}

