/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTree"));
        }
        return this.buildStubTreeFor(file, this.createStubForFile(file));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        PsiFileStubImpl<PsiFile> stub;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    @NotNull
    private StubElement buildStubTreeFor(@NotNull PsiElement root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<PsiElement> parentElements = new Stack<PsiElement>();
        parentElements.push(root);
        parentStubs.push(parentStub);
        while (!parentElements.isEmpty()) {
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            PsiElement elt = (PsiElement)parentElements.pop();
            if (elt instanceof StubBasedPsiElement) {
                IStubElementType type2 = ((StubBasedPsiElement)elt).getElementType();
                if (type2.shouldCreateStub(elt.getNode())) {
                    Object s = type2.createStub(elt, stub);
                    stub = s;
                }
            } else {
                IElementType type3;
                ASTNode node2 = elt.getNode();
                IElementType iElementType = type3 = node2 == null ? null : node2.getElementType();
                if (type3 instanceof IStubElementType && ((IStubElementType)type3).shouldCreateStub(node2)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type3 + ", PSI: " + elt);
                }
            }
            for (PsiElement child = elt.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (this.skipChildProcessingWhenBuildingStubs(elt, child)) continue;
                parentStubs.push(stub);
                parentElements.push(child);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        return stubElement;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    @NotNull
    protected StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<ASTNode> parentNodes = new Stack<ASTNode>();
        parentNodes.push(root);
        parentStubs.push(parentStub);
        while (!parentStubs.isEmpty()) {
            IStubElementType type2;
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            ASTNode node2 = (ASTNode)parentNodes.pop();
            IElementType nodeType = node2.getElementType();
            if (nodeType instanceof IStubElementType && (type2 = (IStubElementType)nodeType).shouldCreateStub(node2)) {
                Object s;
                PsiElement element = node2.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type2 + ", PSI: " + element);
                }
                LOG.assertTrue((stub = (s = type2.createStub(element, stub))) != null, element);
            }
            for (ASTNode childNode = node2.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (this.skipChildProcessingWhenBuildingStubs(node2, childNode)) continue;
                parentNodes.push(childNode);
                parentStubs.push(stub);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        return stubElement;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

