/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNameValuePairImpl
extends JavaStubPsiElement<PsiNameValuePairStub>
implements PsiNameValuePair {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");

    public PsiNameValuePairImpl(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.NAME_VALUE_PAIR);
    }

    public PsiNameValuePairImpl(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "<init>"));
        }
        super(node2);
    }

    @Override
    @NotNull
    public NameValuePairElement getNode() {
        NameValuePairElement nameValuePairElement = (NameValuePairElement)super.getNode();
        if (nameValuePairElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "getNode"));
        }
        return nameValuePairElement;
    }

    @Override
    public String getName() {
        PsiNameValuePairStub stub = (PsiNameValuePairStub)this.getStub();
        if (stub == null) {
            PsiIdentifier nameIdentifier = this.getNameIdentifier();
            return nameIdentifier == null ? null : nameIdentifier.getText();
        }
        return stub.getName();
    }

    @Override
    public String getLiteralValue() {
        PsiNameValuePairStub stub = (PsiNameValuePairStub)this.getStub();
        if (stub == null) {
            PsiAnnotationMemberValue value = this.getValue();
            return value instanceof PsiLiteralExpression ? StringUtil.unquoteString(value.getText()) : null;
        }
        return stub.getValue();
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        ASTNode node2 = this.getNode().findChildByRole(9);
        return node2 == null ? null : (PsiIdentifier)node2.getPsi();
    }

    @Override
    public PsiAnnotationMemberValue getValue() {
        ASTNode node2 = this.getNode().findChildByRole(249);
        return node2 == null ? null : (PsiAnnotationMemberValue)node2.getPsi();
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "setValue"));
        }
        this.getValue().replace(newValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = this.getValue();
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "setValue"));
        }
        return psiAnnotationMemberValue;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @Nullable
            private PsiClass getReferencedClass() {
                LOG.assertTrue(PsiNameValuePairImpl.this.getParent() instanceof PsiAnnotationParameterList && PsiNameValuePairImpl.this.getParent().getParent() instanceof PsiAnnotation);
                PsiAnnotation annotation2 = (PsiAnnotation)PsiNameValuePairImpl.this.getParent().getParent();
                PsiJavaCodeReferenceElement nameRef = annotation2.getNameReferenceElement();
                if (nameRef == null) {
                    return null;
                }
                PsiElement target = nameRef.resolve();
                return target instanceof PsiClass ? (PsiClass)target : null;
            }

            @Override
            public PsiElement getElement() {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    return nameIdentifier;
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public TextRange getRangeInElement() {
                PsiIdentifier id = PsiNameValuePairImpl.this.getNameIdentifier();
                if (id != null) {
                    return new TextRange(0, id.getTextLength());
                }
                return TextRange.EMPTY_RANGE;
            }

            @Override
            public PsiElement resolve() {
                PsiClass refClass = this.getReferencedClass();
                if (refClass == null) {
                    return null;
                }
                String name = PsiNameValuePairImpl.this.getName();
                if (name == null) {
                    name = "value";
                }
                MethodSignature signature = MethodSignatureUtil.createMethodSignature(name, PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                return MethodSignatureUtil.findMethodBySignature(refClass, signature, false);
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                String name = PsiNameValuePairImpl.this.getName();
                String string = name != null ? name : "value";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "getCanonicalText"));
                }
                return string;
            }

            @Override
            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiImplUtil.setName(nameIdentifier, newElementName);
                } else if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(PsiNameValuePairImpl.this.getNode().getFirstChildNode().getElementType())) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance(PsiNameValuePairImpl.this.getProject()).getElementFactory();
                    nameIdentifier = factory.createIdentifier(newElementName);
                    PsiNameValuePairImpl.this.addBefore(nameIdentifier, SourceTreeToPsiMap.treeElementToPsi(PsiNameValuePairImpl.this.getNode().getFirstChildNode()));
                }
                return PsiNameValuePairImpl.this;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "bindToElement"));
                }
                throw new IncorrectOperationException("Not implemented");
            }

            @Override
            public boolean isReferenceTo(PsiElement element) {
                return element instanceof PsiMethod && element.equals(this.resolve());
            }

            @Override
            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            @Override
            public boolean isSoft() {
                return false;
            }
        };
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitNameValuePair(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiNameValuePair";
    }
}

