/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    private LightTreeUtil() {
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull IElementType type2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        List<LighterASTNode> children = tree.getChildren(node2);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type2) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "firstChildOfType"));
        }
        List<LighterASTNode> children = tree.getChildren(node2);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull IElementType type2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node2, type2);
        assert (child != null) : "Required child " + type2 + " not found in " + node2.getTokenType() + ": " + tree.getChildren(node2);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        return lighterASTNode;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node2, types);
        assert (child != null) : "Required child " + types + " not found in " + node2.getTokenType() + ": " + tree.getChildren(node2);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "requiredChildOfType"));
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull IElementType type2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        List<LighterASTNode> result2 = null;
        List<LighterASTNode> children = tree.getChildren(node2);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type2) continue;
            if (result2 == null) {
                result2 = new SmartList<LighterASTNode>();
            }
            result2.add(child);
        }
        List<LighterASTNode> list = result2 != null ? result2 : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        return list;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        List<LighterASTNode> result2 = null;
        List<LighterASTNode> children = tree.getChildren(node2);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (!types.contains(child.getTokenType())) continue;
            if (result2 == null) {
                result2 = new SmartList<LighterASTNode>();
            }
            result2.add(child);
        }
        List<LighterASTNode> list = result2 != null ? result2 : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "getChildrenOfType"));
        }
        return list;
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        int length = node2.getEndOffset() - node2.getStartOffset();
        if (length < 0) {
            length = 0;
            Logger.getInstance(LightTreeUtil.class).error("tree=" + tree + " node=" + node2);
        }
        StringBuilder buffer = new StringBuilder(length);
        LightTreeUtil.toBuffer(tree, node2, buffer, skipTypes);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toFilteredString"));
        }
        return string;
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node2, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LightTreeUtil", "toBuffer"));
        }
        if (skipTypes != null && skipTypes.contains(node2.getTokenType())) {
            return;
        }
        if (node2 instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node2).getText());
            return;
        }
        if (node2 instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node2).getText());
            return;
        }
        List<LighterASTNode> children = tree.getChildren(node2);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, children.get(i), buffer, skipTypes);
        }
    }
}

