/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.Equality;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private final AtomicLong myModification = new AtomicLong(0L);

    ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "getNode"));
        }
        return this.myObject2NodeMap.get(object);
    }

    ObjectNode<T> putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node2) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "putNode"));
        }
        return node2 == null ? this.myObject2NodeMap.remove(object) : this.myObject2NodeMap.put(object, node2);
    }

    @NotNull
    final List<ObjectNode<T>> getNodesInExecution() {
        List<ObjectNode<T>> list = this.myExecutedNodes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "getNodesInExecution"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent, @NotNull T child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/objectTree/ObjectTree", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/objectTree/ObjectTree", "register"));
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> parentNode = this.getOrCreateNodeFor(parent, null);
            ObjectNode<T> childNode = this.getNode(child);
            if (childNode == null) {
                childNode = this.createNodeFor(child, parentNode, Disposer.isDebugMode() ? new Throwable() : null);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(childNode, child);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    private void checkWasNotAddedAlready(@NotNull ObjectNode<T> childNode, @NotNull T child) {
        boolean childIsInTree;
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/util/objectTree/ObjectTree", "checkWasNotAddedAlready"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/objectTree/ObjectTree", "checkWasNotAddedAlready"));
        }
        ObjectNode<T> parent = childNode.getParent();
        boolean bl = childIsInTree = parent != null;
        if (!childIsInTree) {
            return;
        }
        while (parent != null) {
            if (parent.getObject() == child) {
                LOG.error(child + " was already added as a child of: " + parent);
            }
            parent = parent.getParent();
        }
    }

    @NotNull
    private ObjectNode<T> getOrCreateNodeFor(@NotNull T object, @Nullable ObjectNode<T> defaultParent) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "getOrCreateNodeFor"));
        }
        ObjectNode<T> node2 = this.getNode(object);
        if (node2 != null) {
            ObjectNode<T> objectNode = node2;
            if (objectNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "getOrCreateNodeFor"));
            }
            return objectNode;
        }
        ObjectNode<T> objectNode = this.createNodeFor(object, defaultParent, Disposer.isDebugMode() ? new Throwable() : null);
        if (objectNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "getOrCreateNodeFor"));
        }
        return objectNode;
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode, @Nullable Throwable trace) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "createNodeFor"));
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification(), trace);
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/objectTree/ObjectTree", "createNodeFor"));
        }
        return objectNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean executeAll(@NotNull T object, boolean disposeTree, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        ObjectNode<T> node2;
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "executeAll"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/util/objectTree/ObjectTree", "executeAll"));
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            node2 = this.getNode(object);
        }
        if (node2 == null) {
            if (processUnregistered) {
                this.executeUnregistered(object, action);
                return true;
            }
            return false;
        }
        node2.execute(disposeTree, action);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        if (recursiveGuard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursiveGuard", "com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/util/objectTree/ObjectTree", "executeActionWithRecursiveGuard"));
        }
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, Equality.IDENTITY) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, Equality.IDENTITY);
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "executeUnregistered"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/util/objectTree/ObjectTree", "executeUnregistered"));
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action);
    }

    void removeRootObject(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "removeRootObject"));
        }
        this.myRootObjects.remove(object);
    }

    private void fireRegistered(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "fireRegistered"));
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/objectTree/ObjectTree", "fireExecuted"));
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
    }
}

