/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.TypeConstructor;

public abstract class AbstractClassTypeConstructor
implements TypeConstructor {
    public final int hashCode() {
        return AbstractClassTypeConstructor.hashCode(this);
    }

    public boolean equals(Object obj) {
        return AbstractClassTypeConstructor.equals(this, obj);
    }

    public static boolean equals(@NotNull TypeConstructor me, Object other) {
        if (me == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "org/jetbrains/kotlin/types/AbstractClassTypeConstructor", "equals"));
        }
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        ClassifierDescriptor myDescriptor = me.getDeclarationDescriptor();
        ClassifierDescriptor otherDescriptor = ((TypeConstructor)other).getDeclarationDescriptor();
        if (myDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(myDescriptor) || otherDescriptor != null && !AbstractClassTypeConstructor.hasMeaningfulFqName(otherDescriptor)) {
            return me == other;
        }
        if (myDescriptor == otherDescriptor) {
            return true;
        }
        if (myDescriptor instanceof ClassDescriptor && otherDescriptor instanceof ClassDescriptor) {
            FqNameUnsafe otherFqName = DescriptorUtils.getFqName(otherDescriptor);
            FqNameUnsafe myFqName = DescriptorUtils.getFqName(myDescriptor);
            return myFqName.equals(otherFqName);
        }
        return false;
    }

    public static int hashCode(@NotNull TypeConstructor me) {
        if (me == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "org/jetbrains/kotlin/types/AbstractClassTypeConstructor", "hashCode"));
        }
        ClassifierDescriptor descriptor = me.getDeclarationDescriptor();
        if (descriptor instanceof ClassDescriptor && AbstractClassTypeConstructor.hasMeaningfulFqName(descriptor)) {
            return DescriptorUtils.getFqName(descriptor).hashCode();
        }
        return System.identityHashCode(me);
    }

    private static boolean hasMeaningfulFqName(@NotNull ClassifierDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/AbstractClassTypeConstructor", "hasMeaningfulFqName"));
        }
        return !ErrorUtils.isError(descriptor) && !DescriptorUtils.isLocal(descriptor);
    }
}

