/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

public class FileBasedDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final StorageManager storageManager;
    private final NotNullLazyValue<Index> index;

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, final @NotNull Collection<JetFile> files) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "<init>"));
        }
        super(storageManager);
        this.storageManager = storageManager;
        this.index = storageManager.createLazyValue(new Function0<Index>(){

            @Override
            public Index invoke() {
                return FileBasedDeclarationProviderFactory.computeFilesByPackage(files);
            }
        });
    }

    @NotNull
    private static Index computeFilesByPackage(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "computeFilesByPackage"));
        }
        Index index2 = new Index();
        for (JetFile file : files) {
            FqName packageFqName = file.getPackageFqName();
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, packageFqName);
            index2.filesByPackage.put(packageFqName, file);
        }
        Index index3 = index2;
        if (index3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "computeFilesByPackage"));
        }
        return index3;
    }

    private static void addMeAndParentPackages(@NotNull Index index2, @NotNull FqName name) {
        if (index2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "addMeAndParentPackages"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "addMeAndParentPackages"));
        }
        index2.declaredPackages.add(name);
        if (!name.isRoot()) {
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, name.parent());
        }
    }

    boolean isPackageDeclaredExplicitly(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "isPackageDeclaredExplicitly"));
        }
        return ((Index)this.index.invoke()).declaredPackages.contains(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(final @NotNull FqName parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getAllDeclaredSubPackagesOf"));
        }
        return Collections2.filter(((Index)this.index.invoke()).declaredPackages, new Predicate<FqName>(){

            @Override
            public boolean apply(FqName fqName2) {
                return !fqName2.isRoot() && fqName2.parent().equals(parent);
            }
        });
    }

    @Override
    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "createPackageMemberDeclarationProvider"));
        }
        if (this.isPackageDeclaredExplicitly(packageFqName)) {
            return new FileBasedPackageMemberDeclarationProvider(this.storageManager, packageFqName, this, ((Index)this.index.invoke()).filesByPackage.get(packageFqName));
        }
        return null;
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull JetClassLikeInfo classLikeInfo) {
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
        }
        if (!((Index)this.index.invoke()).filesByPackage.containsKey(classLikeInfo.getContainingPackageFqName())) {
            throw new IllegalStateException("This factory doesn't know about this class: " + classLikeInfo);
        }
        PsiBasedClassMemberDeclarationProvider psiBasedClassMemberDeclarationProvider = new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
        if (psiBasedClassMemberDeclarationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
        }
        return psiBasedClassMemberDeclarationProvider;
    }

    private static class Index {
        private final Multimap<FqName, JetFile> filesByPackage = HashMultimap.create();
        private final Set<FqName> declaredPackages = Sets.newHashSet();

        private Index() {
        }
    }
}

