/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisParameters;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.storage.ExceptionTracker;
import org.jetbrains.kotlin.storage.StorageManager;

public class TopDownAnalysisContext
implements BodiesResolveContext {
    private final DataFlowInfo outerDataFlowInfo;
    private final Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> classes;
    private final Map<JetClassInitializer, ClassDescriptorWithResolutionScopes> anonymousInitializers;
    private final Set<JetFile> files;
    private final Map<JetSecondaryConstructor, ConstructorDescriptor> secondaryConstructors;
    private final Map<JetDeclaration, JetScope> declaringScopes;
    private final Map<JetNamedFunction, SimpleFunctionDescriptor> functions;
    private final Map<JetProperty, PropertyDescriptor> properties;
    private final Map<JetParameter, PropertyDescriptor> primaryConstructorParameterProperties;
    private Map<JetCallableDeclaration, CallableMemberDescriptor> members;
    private final Map<JetScript, ScriptDescriptor> scripts;
    private final TopDownAnalysisParameters topDownAnalysisParameters;
    private StringBuilder debugOutput;

    public TopDownAnalysisContext(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull DataFlowInfo outerDataFlowInfo) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "<init>"));
        }
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "<init>"));
        }
        this.classes = Maps.newLinkedHashMap();
        this.anonymousInitializers = Maps.newLinkedHashMap();
        this.files = new LinkedHashSet<JetFile>();
        this.secondaryConstructors = Maps.newLinkedHashMap();
        this.declaringScopes = Maps.newHashMap();
        this.functions = Maps.newLinkedHashMap();
        this.properties = Maps.newLinkedHashMap();
        this.primaryConstructorParameterProperties = Maps.newHashMap();
        this.members = null;
        this.scripts = Maps.newLinkedHashMap();
        this.topDownAnalysisParameters = topDownAnalysisParameters;
        this.outerDataFlowInfo = outerDataFlowInfo;
    }

    @Override
    @NotNull
    public TopDownAnalysisParameters getTopDownAnalysisParameters() {
        TopDownAnalysisParameters topDownAnalysisParameters = this.topDownAnalysisParameters;
        if (topDownAnalysisParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getTopDownAnalysisParameters"));
        }
        return topDownAnalysisParameters;
    }

    public void debug(Object message) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message).append("\n");
        }
    }

    @Override
    public Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> getDeclaredClasses() {
        return this.classes;
    }

    @Override
    public Map<JetClassInitializer, ClassDescriptorWithResolutionScopes> getAnonymousInitializers() {
        return this.anonymousInitializers;
    }

    @Override
    public Map<JetSecondaryConstructor, ConstructorDescriptor> getSecondaryConstructors() {
        return this.secondaryConstructors;
    }

    @Override
    @NotNull
    public StorageManager getStorageManager() {
        StorageManager storageManager = this.topDownAnalysisParameters.getStorageManager();
        if (storageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getStorageManager"));
        }
        return storageManager;
    }

    @Override
    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.topDownAnalysisParameters.getExceptionTracker();
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    @Override
    public Collection<JetFile> getFiles() {
        return this.files;
    }

    public void addFile(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "addFile"));
        }
        this.files.add(file);
    }

    @Override
    @NotNull
    public Map<JetScript, ScriptDescriptor> getScripts() {
        Map<JetScript, ScriptDescriptor> map = this.scripts;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getScripts"));
        }
        return map;
    }

    public Map<JetParameter, PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    @Override
    public Map<JetProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    public Function<JetDeclaration, JetScope> getDeclaringScopes() {
        return Functions.forMap(this.declaringScopes);
    }

    public void registerDeclaringScope(@NotNull JetDeclaration declaration, @NotNull JetScope scope2) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "registerDeclaringScope"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "registerDeclaringScope"));
        }
        this.declaringScopes.put(declaration, scope2);
    }

    @Override
    public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @NotNull
    public Map<JetCallableDeclaration, CallableMemberDescriptor> getMembers() {
        if (this.members == null) {
            this.members = Maps.newLinkedHashMap();
            this.members.putAll(this.functions);
            this.members.putAll(this.properties);
            this.members.putAll(this.primaryConstructorParameterProperties);
        }
        Map<JetCallableDeclaration, CallableMemberDescriptor> map = this.members;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getMembers"));
        }
        return map;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.outerDataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getOuterDataFlowInfo"));
        }
        return dataFlowInfo;
    }

    @NotNull
    public Collection<ClassDescriptorWithResolutionScopes> getAllClasses() {
        List<ClassDescriptorWithResolutionScopes> scriptClasses = KotlinPackage.map(this.getScripts().values(), new Function1<ScriptDescriptor, ClassDescriptorWithResolutionScopes>(){

            @Override
            public ClassDescriptorWithResolutionScopes invoke(ScriptDescriptor scriptDescriptor) {
                return (ClassDescriptorWithResolutionScopes)scriptDescriptor.getClassDescriptor();
            }
        });
        List<ClassDescriptorWithResolutionScopes> list = KotlinPackage.plus(this.getDeclaredClasses().values(), scriptClasses);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/TopDownAnalysisContext", "getAllClasses"));
        }
        return list;
    }
}

