/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetWhenCondition;

public class JetWhenConditionInRange
extends JetWhenCondition {
    public JetWhenConditionInRange(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetWhenConditionInRange", "<init>"));
        }
        super(node2);
    }

    public boolean isNegated() {
        return this.getNode().findChildByType(JetTokens.NOT_IN) != null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getRangeExpression() {
        for (ASTNode node2 = this.getOperationReference().getNode().getTreeNext(); node2 != null; node2 = node2.getTreeNext()) {
            PsiElement psi = node2.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetWhenConditionInRange", "accept"));
        }
        return visitor2.visitWhenConditionInRange(this, data2);
    }

    public JetSimpleNameExpression getOperationReference() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
    }
}

