/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetDeclarationImpl;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetMultiDeclaration
extends JetDeclarationImpl {
    public JetMultiDeclaration(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetMultiDeclaration", "<init>"));
        }
        super(node2);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetMultiDeclaration", "accept"));
        }
        return visitor2.visitMultiDeclaration(this, data2);
    }

    @NotNull
    public List<JetMultiDeclarationEntry> getEntries() {
        List<JetMultiDeclarationEntry> list = this.findChildrenByType(JetNodeTypes.MULTI_VARIABLE_DECLARATION_ENTRY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetMultiDeclaration", "getEntries"));
        }
        return list;
    }

    @Nullable
    public JetExpression getInitializer() {
        ASTNode eqNode = this.getNode().findChildByType(JetTokens.EQ);
        if (eqNode == null) {
            return null;
        }
        return PsiTreeUtil.getNextSiblingOfType(eqNode.getPsi(), JetExpression.class);
    }

    @Nullable
    public ASTNode getValOrVarNode() {
        return this.getNode().findChildByType(TokenSet.create(JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD));
    }

    @Nullable
    public PsiElement getRPar() {
        return this.findChildByType(JetTokens.RPAR);
    }

    @Nullable
    public PsiElement getLPar() {
        return this.findChildByType(JetTokens.LPAR);
    }
}

