/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataPackage;
import com.intellij.psi.PsiElement;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.CleanPackage;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.InsertionPoint;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.context.StatementContext;
import org.jetbrains.kotlin.js.inline.util.UtilPackage;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

public class JsInliner
extends JsVisitorWithContextImpl {
    private final IdentityHashMap<JsName, JsFunction> functions;
    private final Stack<JsInliningContext> inliningContexts;
    private final Set<JsFunction> processedFunctions;
    private final Set<JsFunction> inProcessFunctions;
    private final FunctionReader functionReader;
    private final DiagnosticSink trace;
    private final Stack<JsFunction> namedFunctionsStack;
    private final LinkedList<JsCallInfo> inlineCallInfos;
    private boolean lastStatementWasShifted;

    public static JsProgram process(@NotNull TranslationContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "process"));
        }
        JsProgram program = context2.program();
        IdentityHashMap<JsName, JsFunction> functions2 = UtilPackage.collectNamedFunctions(program);
        JsInliner inliner = new JsInliner(functions2, new FunctionReader(context2), context2.bindingTrace());
        inliner.accept(program);
        CleanPackage.removeUnusedFunctionDefinitions(program, functions2);
        return program;
    }

    private JsInliner(@NotNull IdentityHashMap<JsName, JsFunction> functions2, @NotNull FunctionReader functionReader, @NotNull DiagnosticSink trace) {
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/kotlin/js/inline/JsInliner", "<init>"));
        }
        if (functionReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReader", "org/jetbrains/kotlin/js/inline/JsInliner", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/js/inline/JsInliner", "<init>"));
        }
        this.inliningContexts = new Stack();
        this.processedFunctions = UtilPackage.IdentitySet();
        this.inProcessFunctions = UtilPackage.IdentitySet();
        this.namedFunctionsStack = new Stack();
        this.inlineCallInfos = new LinkedList();
        this.lastStatementWasShifted = false;
        this.functions = functions2;
        this.functionReader = functionReader;
        this.trace = trace;
    }

    @Override
    public boolean visit(JsFunction function, JsContext context2) {
        this.inliningContexts.push(new JsInliningContext(function));
        assert (!this.inProcessFunctions.contains(function)) : "Inliner has revisited function";
        this.inProcessFunctions.add(function);
        if (this.functions.containsValue(function)) {
            this.namedFunctionsStack.push(function);
        }
        return super.visit(function, context2);
    }

    @Override
    public void endVisit(JsFunction function, JsContext context2) {
        super.endVisit(function, context2);
        UtilPackage.refreshLabelNames(this.getInliningContext().newNamingContext(), function);
        CleanPackage.removeUnusedLocalFunctionDeclarations(function);
        this.processedFunctions.add(function);
        assert (this.inProcessFunctions.contains(function));
        this.inProcessFunctions.remove(function);
        this.inliningContexts.pop();
        if (!this.namedFunctionsStack.empty() && this.namedFunctionsStack.peek() == function) {
            this.namedFunctionsStack.pop();
        }
    }

    @Override
    public boolean visit(JsInvocation call, JsContext context2) {
        if (JsInliner.shouldInline(call) && this.canInline(call)) {
            JsFunction definition;
            JsFunction containingFunction = this.getCurrentNamedFunction();
            if (containingFunction != null) {
                this.inlineCallInfos.add(new JsCallInfo(call, containingFunction));
            }
            if (this.inProcessFunctions.contains(definition = this.getFunctionContext().getFunctionDefinition(call))) {
                this.reportInlineCycle(call, definition);
                return false;
            }
            if (!this.processedFunctions.contains(definition)) {
                this.accept(definition);
            }
            this.inline(call, context2);
        }
        return !this.lastStatementWasShifted;
    }

    @Override
    public void endVisit(JsInvocation x, JsContext ctx) {
        JsCallInfo lastCallInfo = null;
        if (!this.inlineCallInfos.isEmpty()) {
            lastCallInfo = this.inlineCallInfos.getLast();
        }
        if (lastCallInfo != null && lastCallInfo.call == x) {
            this.inlineCallInfos.removeLast();
        }
    }

    private void inline(@NotNull JsInvocation call, @NotNull JsContext context2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "inline"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/inline/JsInliner", "inline"));
        }
        JsInliningContext inliningContext = this.getInliningContext();
        FunctionContext functionContext = this.getFunctionContext();
        functionContext.declareFunctionConstructorCalls(call.getArguments());
        InlineableResult inlineableResult = FunctionInlineMutator.getInlineableCallReplacement(call, inliningContext);
        JsStatement inlineableBody = inlineableResult.getInlineableBody();
        JsExpression resultExpression = inlineableResult.getResultExpression();
        StatementContext statementContext = inliningContext.getStatementContext();
        this.accept(inlineableBody);
        if (resultExpression == null) {
            statementContext.removeCurrentStatement();
        } else {
            context2.replaceMe(resultExpression);
        }
        statementContext.shiftCurrentStatementForward();
        InsertionPoint<JsStatement> insertionPoint = statementContext.getInsertionPoint();
        insertionPoint.insertAllAfter(JsAstUtils.flattenStatement(inlineableBody));
    }

    @Override
    protected <T extends JsNode> void doTraverse(T node2, JsContext ctx) {
        if (node2 instanceof JsStatement) {
            this.lastStatementWasShifted = false;
        }
        if (!this.lastStatementWasShifted) {
            super.doTraverse(node2, ctx);
        }
    }

    @NotNull
    private JsInliningContext getInliningContext() {
        JsInliningContext jsInliningContext = this.inliningContexts.peek();
        if (jsInliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner", "getInliningContext"));
        }
        return jsInliningContext;
    }

    @NotNull
    FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getInliningContext().getFunctionContext();
        if (functionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner", "getFunctionContext"));
        }
        return functionContext;
    }

    @Nullable
    private JsFunction getCurrentNamedFunction() {
        if (this.namedFunctionsStack.empty()) {
            return null;
        }
        return this.namedFunctionsStack.peek();
    }

    private void reportInlineCycle(@NotNull JsInvocation call, @NotNull JsFunction calledFunction) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "reportInlineCycle"));
        }
        if (calledFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledFunction", "org/jetbrains/kotlin/js/inline/JsInliner", "reportInlineCycle"));
        }
        MetadataPackage.setInlineStrategy(call, InlineStrategy.NOT_INLINE);
        Iterator<JsCallInfo> it = this.inlineCallInfos.descendingIterator();
        while (it.hasNext()) {
            JsCallInfo callInfo = it.next();
            PsiElement psiElement = MetadataPackage.getPsiElement(callInfo.call);
            if (psiElement != null) {
                this.trace.report(ErrorsJs.INLINE_CALL_CYCLE.on(psiElement));
            }
            if (callInfo.containingFunction != calledFunction) continue;
            break;
        }
    }

    private boolean canInline(@NotNull JsInvocation call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "canInline"));
        }
        FunctionContext functionContext = this.getFunctionContext();
        return functionContext.hasFunctionDefinition(call);
    }

    private static boolean shouldInline(@NotNull JsInvocation call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner", "shouldInline"));
        }
        InlineStrategy strategy = MetadataPackage.getInlineStrategy(call);
        return strategy != null && strategy.isInline();
    }

    private static class JsCallInfo {
        @NotNull
        public final JsInvocation call;
        @NotNull
        public final JsFunction containingFunction;

        private JsCallInfo(@NotNull JsInvocation call, @NotNull JsFunction function) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/js/inline/JsInliner$JsCallInfo", "<init>"));
            }
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/inline/JsInliner$JsCallInfo", "<init>"));
            }
            this.call = call;
            this.containingFunction = function;
        }
    }

    private class JsInliningContext
    implements InliningContext {
        private final FunctionContext functionContext;

        JsInliningContext(JsFunction function) {
            this.functionContext = new FunctionContext(function, this, JsInliner.this.functionReader){

                @Override
                @Nullable
                protected JsFunction lookUpStaticFunction(@Nullable JsName functionName) {
                    return (JsFunction)JsInliner.this.functions.get(functionName);
                }
            };
        }

        @Override
        @NotNull
        public NamingContext newNamingContext() {
            JsScope scope2 = this.getFunctionContext().getScope();
            InsertionPoint<JsStatement> insertionPoint = this.getStatementContext().getInsertionPoint();
            NamingContext namingContext = new NamingContext(scope2, insertionPoint);
            if (namingContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext", "newNamingContext"));
            }
            return namingContext;
        }

        @Override
        @NotNull
        public StatementContext getStatementContext() {
            StatementContext statementContext = new StatementContext(){

                @Override
                @NotNull
                public JsContext getCurrentStatementContext() {
                    JsContext jsContext = JsInliner.this.getLastStatementLevelContext();
                    if (jsContext == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext$2", "getCurrentStatementContext"));
                    }
                    return jsContext;
                }

                @Override
                @NotNull
                protected JsStatement getEmptyStatement() {
                    JsEmpty jsEmpty = JsInliningContext.this.getFunctionContext().getEmpty();
                    if (jsEmpty == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext$2", "getEmptyStatement"));
                    }
                    return jsEmpty;
                }

                @Override
                public void shiftCurrentStatementForward() {
                    super.shiftCurrentStatementForward();
                    JsInliner.this.lastStatementWasShifted = true;
                }
            };
            if (statementContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext", "getStatementContext"));
            }
            return statementContext;
        }

        @Override
        @NotNull
        public FunctionContext getFunctionContext() {
            FunctionContext functionContext = this.functionContext;
            if (functionContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext", "getFunctionContext"));
            }
            return functionContext;
        }
    }
}

