/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.GlobalContextImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.TopDownAnalysisParameters;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public final class TopDownAnalyzerFacadeForJS {
    public static final List<ImportPath> DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.js.*"));

    private TopDownAnalyzerFacadeForJS() {
    }

    @NotNull
    public static JsAnalysisResult analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingTraceContext trace = new BindingTraceContext();
        ModuleDescriptorImpl module = TopDownAnalyzerFacadeForJS.createJsModule("<" + config.getModuleId() + ">");
        module.addDependencyOnModule(module);
        module.addDependencyOnModule(KotlinBuiltIns.getInstance().getBuiltInsModule());
        for (ModuleDescriptorImpl moduleDescriptor : config.getModuleDescriptors()) {
            module.addDependencyOnModule(moduleDescriptor);
        }
        module.seal();
        JsAnalysisResult jsAnalysisResult = TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files, trace, module, config);
        if (jsAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return jsAnalysisResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<JetFile> files, @NotNull BindingTrace trace, @NotNull ModuleDescriptorImpl module, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        Project project = config.getProject();
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), false, false);
        Collection<JetFile> allFiles = Config.withJsLibAdded(files, config);
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, trace, module, new FileBasedDeclarationProviderFactory(topDownAnalysisParameters.getStorageManager(), allFiles));
        injector.getLazyTopDownAnalyzerForTopLevel().analyzeFiles(topDownAnalysisParameters, files, Collections.emptyList());
        JsAnalysisResult jsAnalysisResult = JsAnalysisResult.success(trace, (ModuleDescriptor)module);
        JsAnalysisResult jsAnalysisResult2 = jsAnalysisResult;
        if (jsAnalysisResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        return jsAnalysisResult2;
        finally {
            injector.destroy();
        }
    }

    public static void checkForErrors(@NotNull Collection<JetFile> allFiles, @NotNull BindingContext bindingContext) {
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (JetFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJsModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "createJsModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, PlatformToKotlinClassMap.EMPTY);
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "createJsModule"));
        }
        return moduleDescriptorImpl;
    }
}

