/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.ControlFlowAnalyzer;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.ScriptBodyResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.types.expressions.LocalClassifierAnalyzer;
import org.jetbrains.kotlin.types.reflect.ReflectionTypes;

public class InjectorForBodyResolve {
    private final Project project;
    private final GlobalContext globalContext;
    private final StorageManager storageManager;
    private final BindingTrace bindingTrace;
    private final ModuleDescriptor moduleDescriptor;
    private final KotlinBuiltIns kotlinBuiltIns;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    private final AdditionalCheckerProvider additionalCheckerProvider;
    private final StatementFilter statementFilter;
    private final BodyResolver bodyResolver;
    private final AnnotationResolver annotationResolver;
    private final CallResolver callResolver;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final ExpressionTypingComponents expressionTypingComponents;
    private final ControlStructureTypingUtils controlStructureTypingUtils;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final ExpressionTypingUtils expressionTypingUtils;
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    private final LocalClassifierAnalyzer localClassifierAnalyzer;
    private final DescriptorResolver descriptorResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final TypeResolver typeResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final TypeResolver.FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final TypeLazinessToken typeLazinessToken;
    private final FunctionDescriptorResolver functionDescriptorResolver;
    private final ReflectionTypes reflectionTypes;
    private final CallExpressionResolver callExpressionResolver;
    private final CallCompleter callCompleter;
    private final CandidateResolver candidateResolver;
    private final TaskPrioritizer taskPrioritizer;
    private final ControlFlowAnalyzer controlFlowAnalyzer;
    private final DeclarationsChecker declarationsChecker;
    private final ModifiersChecker modifiersChecker;
    private final FunctionAnalyzerExtension functionAnalyzerExtension;
    private final ScriptBodyResolver scriptBodyResolver;

    public InjectorForBodyResolve(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor, @NotNull AdditionalCheckerProvider additionalCheckerProvider, @NotNull StatementFilter statementFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/di/InjectorForBodyResolve", "<init>"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/kotlin/di/InjectorForBodyResolve", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/di/InjectorForBodyResolve", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/di/InjectorForBodyResolve", "<init>"));
        }
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/kotlin/di/InjectorForBodyResolve", "<init>"));
        }
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/di/InjectorForBodyResolve", "<init>"));
        }
        this.project = project;
        this.globalContext = globalContext;
        this.storageManager = globalContext.getStorageManager();
        this.bindingTrace = bindingTrace;
        this.moduleDescriptor = moduleDescriptor;
        this.kotlinBuiltIns = moduleDescriptor.getBuiltIns();
        this.platformToKotlinClassMap = moduleDescriptor.getPlatformToKotlinClassMap();
        this.additionalCheckerProvider = additionalCheckerProvider;
        this.statementFilter = statementFilter;
        this.bodyResolver = new BodyResolver();
        this.annotationResolver = new AnnotationResolver();
        this.callResolver = new CallResolver();
        this.argumentTypeResolver = new ArgumentTypeResolver();
        this.expressionTypingComponents = new ExpressionTypingComponents();
        this.expressionTypingServices = new ExpressionTypingServices(this.expressionTypingComponents);
        this.controlStructureTypingUtils = new ControlStructureTypingUtils(this.expressionTypingServices);
        this.dynamicTypesSettings = new DynamicTypesSettings();
        this.expressionTypingUtils = new ExpressionTypingUtils(this.expressionTypingServices, this.callResolver, this.kotlinBuiltIns);
        this.forLoopConventionsChecker = new ForLoopConventionsChecker();
        this.descriptorResolver = new DescriptorResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.flexibleTypeCapabilitiesProvider = new TypeResolver.FlexibleTypeCapabilitiesProvider();
        this.typeLazinessToken = new TypeLazinessToken();
        this.typeResolver = new TypeResolver(this.annotationResolver, this.qualifiedExpressionResolver, moduleDescriptor, this.flexibleTypeCapabilitiesProvider, this.storageManager, this.typeLazinessToken, this.dynamicTypesSettings);
        this.functionDescriptorResolver = new FunctionDescriptorResolver(this.typeResolver, this.descriptorResolver, this.annotationResolver, this.storageManager, this.expressionTypingServices, this.kotlinBuiltIns);
        this.localClassifierAnalyzer = new LocalClassifierAnalyzer(this.descriptorResolver, this.functionDescriptorResolver, this.typeResolver, this.annotationResolver);
        this.delegatedPropertyResolver = new DelegatedPropertyResolver();
        this.reflectionTypes = new ReflectionTypes(moduleDescriptor);
        this.callExpressionResolver = new CallExpressionResolver();
        this.candidateResolver = new CandidateResolver();
        this.callCompleter = new CallCompleter(this.argumentTypeResolver, this.candidateResolver);
        this.taskPrioritizer = new TaskPrioritizer(this.storageManager);
        this.controlFlowAnalyzer = new ControlFlowAnalyzer();
        this.declarationsChecker = new DeclarationsChecker();
        this.modifiersChecker = new ModifiersChecker(bindingTrace, additionalCheckerProvider);
        this.functionAnalyzerExtension = new FunctionAnalyzerExtension();
        this.scriptBodyResolver = new ScriptBodyResolver();
        this.bodyResolver.setAnnotationResolver(this.annotationResolver);
        this.bodyResolver.setCallResolver(this.callResolver);
        this.bodyResolver.setControlFlowAnalyzer(this.controlFlowAnalyzer);
        this.bodyResolver.setDeclarationsChecker(this.declarationsChecker);
        this.bodyResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.bodyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.bodyResolver.setFunctionAnalyzerExtension(this.functionAnalyzerExtension);
        this.bodyResolver.setScriptBodyResolverResolver(this.scriptBodyResolver);
        this.bodyResolver.setTrace(bindingTrace);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setStorageManager(this.storageManager);
        this.annotationResolver.setTypeResolver(this.typeResolver);
        this.callResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.callResolver.setCallCompleter(this.callCompleter);
        this.callResolver.setCandidateResolver(this.candidateResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setTaskPrioritizer(this.taskPrioritizer);
        this.callResolver.setTypeResolver(this.typeResolver);
        this.argumentTypeResolver.setBuiltIns(this.kotlinBuiltIns);
        this.argumentTypeResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.argumentTypeResolver.setTypeResolver(this.typeResolver);
        this.expressionTypingServices.setAnnotationResolver(this.annotationResolver);
        this.expressionTypingServices.setBuiltIns(this.kotlinBuiltIns);
        this.expressionTypingServices.setCallExpressionResolver(this.callExpressionResolver);
        this.expressionTypingServices.setCallResolver(this.callResolver);
        this.expressionTypingServices.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingServices.setFunctionDescriptorResolver(this.functionDescriptorResolver);
        this.expressionTypingServices.setProject(project);
        this.expressionTypingServices.setStatementFilter(statementFilter);
        this.expressionTypingServices.setTypeResolver(this.typeResolver);
        this.expressionTypingComponents.setAdditionalCheckerProvider(additionalCheckerProvider);
        this.expressionTypingComponents.setBuiltIns(this.kotlinBuiltIns);
        this.expressionTypingComponents.setCallResolver(this.callResolver);
        this.expressionTypingComponents.setControlStructureTypingUtils(this.controlStructureTypingUtils);
        this.expressionTypingComponents.setDynamicTypesSettings(this.dynamicTypesSettings);
        this.expressionTypingComponents.setExpressionTypingServices(this.expressionTypingServices);
        this.expressionTypingComponents.setExpressionTypingUtils(this.expressionTypingUtils);
        this.expressionTypingComponents.setForLoopConventionsChecker(this.forLoopConventionsChecker);
        this.expressionTypingComponents.setGlobalContext(globalContext);
        this.expressionTypingComponents.setLocalClassifierAnalyzer(this.localClassifierAnalyzer);
        this.expressionTypingComponents.setPlatformToKotlinClassMap(this.platformToKotlinClassMap);
        this.expressionTypingComponents.setReflectionTypes(this.reflectionTypes);
        this.forLoopConventionsChecker.setBuiltIns(this.kotlinBuiltIns);
        this.forLoopConventionsChecker.setExpressionTypingServices(this.expressionTypingServices);
        this.forLoopConventionsChecker.setExpressionTypingUtils(this.expressionTypingUtils);
        this.forLoopConventionsChecker.setProject(project);
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setBuiltIns(this.kotlinBuiltIns);
        this.descriptorResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setStorageManager(this.storageManager);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.delegatedPropertyResolver.setBuiltIns(this.kotlinBuiltIns);
        this.delegatedPropertyResolver.setCallResolver(this.callResolver);
        this.delegatedPropertyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callExpressionResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.candidateResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.controlFlowAnalyzer.setTrace(bindingTrace);
        this.declarationsChecker.setDescriptorResolver(this.descriptorResolver);
        this.declarationsChecker.setModifiersChecker(this.modifiersChecker);
        this.declarationsChecker.setTrace(bindingTrace);
        this.functionAnalyzerExtension.setTrace(bindingTrace);
        this.scriptBodyResolver.setExpressionTypingServices(this.expressionTypingServices);
    }

    @PreDestroy
    public void destroy() {
    }

    public BodyResolver getBodyResolver() {
        return this.bodyResolver;
    }
}

