/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;

public abstract class ArgumentGenerator {
    @NotNull
    public List<Integer> generate(@NotNull List<ResolvedValueArgument> valueArguments2) {
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generate"));
        }
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        boolean maskIsNeeded = false;
        int mask = 0;
        int n = valueArguments2.size();
        for (int i = 0; i < n; ++i) {
            ResolvedValueArgument argument;
            if (i != 0 && i % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            if ((argument = valueArguments2.get(i)) instanceof ExpressionValueArgument) {
                this.generateExpression(i, (ExpressionValueArgument)argument);
                continue;
            }
            if (argument instanceof DefaultValueArgument) {
                maskIsNeeded = true;
                mask |= 1 << i % 32;
                this.generateDefault(i, (DefaultValueArgument)argument);
                continue;
            }
            if (argument instanceof VarargValueArgument) {
                this.generateVararg(i, (VarargValueArgument)argument);
                continue;
            }
            this.generateOther(i, argument);
        }
        if (!maskIsNeeded) {
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generate"));
            }
            return list;
        }
        masks.add(mask);
        ArrayList<Integer> arrayList = masks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generate"));
        }
        return arrayList;
    }

    protected void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generateExpression"));
        }
        throw new UnsupportedOperationException("Unsupported expression value argument #" + i + ": " + argument);
    }

    protected void generateDefault(int i, @NotNull DefaultValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generateDefault"));
        }
        throw new UnsupportedOperationException("Unsupported default value argument #" + i + ": " + argument);
    }

    protected void generateVararg(int i, @NotNull VarargValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generateVararg"));
        }
        throw new UnsupportedOperationException("Unsupported vararg value argument #" + i + ": " + argument);
    }

    protected void generateOther(int i, @NotNull ResolvedValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ArgumentGenerator", "generateOther"));
        }
        throw new UnsupportedOperationException("Unsupported value argument #" + i + ": " + argument);
    }
}

