/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Function1;
import kotlin.Unit;
import kotlin.io.IoPackage;
import kotlin.modules.AllModules;
import kotlin.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.ModuleExecutionException;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class CompileEnvironmentUtil {
    @NotNull
    public static ModuleScriptData loadModuleDescriptions(KotlinPaths paths, String moduleDefinitionFile, MessageCollector messageCollector) {
        File file = new File(moduleDefinitionFile);
        if (!file.exists()) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + moduleDefinitionFile, CompilerMessageLocation.NO_LOCATION);
            ModuleScriptData moduleScriptData = ModuleScriptData.EMPTY;
            if (moduleScriptData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
            }
            return moduleScriptData;
        }
        String extension = FileUtilRt.getExtension(moduleDefinitionFile);
        if ("ktm".equalsIgnoreCase(extension)) {
            ModuleScriptData moduleScriptData = CompileEnvironmentUtil.loadModuleScript(paths, moduleDefinitionFile, messageCollector);
            if (moduleScriptData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
            }
            return moduleScriptData;
        }
        if ("xml".equalsIgnoreCase(extension)) {
            ModuleScriptData moduleScriptData = ModuleXmlParser.parseModuleScript(moduleDefinitionFile, messageCollector);
            if (moduleScriptData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
            }
            return moduleScriptData;
        }
        messageCollector.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + moduleDefinitionFile, CompilerMessageLocation.NO_LOCATION);
        ModuleScriptData moduleScriptData = ModuleScriptData.EMPTY;
        if (moduleScriptData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleDescriptions"));
        }
        return moduleScriptData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static ModuleScriptData loadModuleScript(KotlinPaths paths, String moduleScriptFile, MessageCollector messageCollector) {
        List<Module> modules;
        CompilerConfiguration configuration = new CompilerConfiguration();
        File runtimePath = paths.getRuntimePath();
        if (runtimePath.exists()) {
            configuration.add(JVMConfigurationKeys.CLASSPATH_KEY, runtimePath);
        }
        configuration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, PathUtil.getJdkClassesRoots());
        File jdkAnnotationsPath = paths.getJdkAnnotationsPath();
        if (jdkAnnotationsPath.exists()) {
            configuration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, jdkAnnotationsPath);
        }
        configuration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, moduleScriptFile);
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        Disposable disposable = Disposer.newDisposable();
        try {
            JetCoreEnvironment scriptEnvironment = JetCoreEnvironment.createForProduction(disposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
            GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(scriptEnvironment);
            if (generationState == null) {
                throw new CompileEnvironmentException("Module script " + moduleScriptFile + " analyze failed:\n" + CompileEnvironmentUtil.loadModuleScriptText(moduleScriptFile));
            }
            modules = CompileEnvironmentUtil.runDefineModules(paths, generationState.getFactory());
        }
        finally {
            Disposer.dispose(disposable);
        }
        if (modules == null) {
            throw new CompileEnvironmentException("Module script " + moduleScriptFile + " compilation failed");
        }
        if (modules.isEmpty()) {
            throw new CompileEnvironmentException("No modules where defined by " + moduleScriptFile);
        }
        ModuleScriptData moduleScriptData = new ModuleScriptData(modules);
        if (moduleScriptData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleScript"));
        }
        return moduleScriptData;
    }

    private static List<Module> runDefineModules(KotlinPaths paths, ClassFileFactory factory) {
        GeneratedClassLoader loader;
        File stdlibJar = paths.getRuntimePath();
        if (stdlibJar.exists()) {
            try {
                loader = new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{stdlibJar.toURI().toURL()}, AllModules.class.getClassLoader()), new URL[0]);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            loader = new GeneratedClassLoader(factory, KotlinToJVMBytecodeCompiler.class.getClassLoader(), new URL[0]);
        }
        try {
            Class<?> packageClass = loader.loadClass(PackageClassUtils.getPackageClassName(FqName.ROOT));
            Method method = packageClass.getDeclaredMethod("project", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            ArrayList<Module> answer = new ArrayList<Module>((Collection)AllModules.INSTANCE$.get());
            ((ArrayList)AllModules.INSTANCE$.get()).clear();
            ArrayList<Module> arrayList = answer;
            return arrayList;
        }
        catch (Exception e) {
            throw new ModuleExecutionException(e);
        }
        finally {
            loader.dispose();
        }
    }

    private static void doWriteToJar(ClassFileFactory outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream2 = new JarOutputStream(fos, manifest);
            for (OutputFile outputFile : outputFiles.asList()) {
                stream2.putNextEntry(new JarEntry(outputFile.getRelativePath()));
                stream2.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream2);
            }
            stream2.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, FqName mainClass, ClassFileFactory outputFiles) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream, mainClass, jarRuntime);
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompileEnvironmentException("Invalid jar path " + jarPath, e);
                catch (IOException e2) {
                    throw UtilsPackage.rethrow(e2);
                }
            }
            catch (Throwable throwable) {
                UtilsPackage.closeQuietly(outputStream);
                throw throwable;
            }
        }
        UtilsPackage.closeQuietly(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRuntimeToJar(JarOutputStream stream2) throws IOException {
        File runtimePath = PathUtil.getKotlinPathsForCompiler().getRuntimePath();
        if (!runtimePath.exists()) {
            throw new CompileEnvironmentException("Couldn't find runtime library");
        }
        JarInputStream jis = new JarInputStream(new FileInputStream(runtimePath));
        try {
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                if (!FileUtilRt.extensionEquals(e.getName(), "class")) continue;
                stream2.putNextEntry(e);
                FileUtil.copy(jis, stream2);
            }
        }
        finally {
            jis.close();
        }
    }

    private static String loadModuleScriptText(String moduleScriptFile) {
        try {
            return FileUtil.loadFile(new File(moduleScriptFile));
        }
        catch (IOException e) {
            return "Can't load module script text:\n" + OutputMessageUtil.renderException(e);
        }
    }

    @NotNull
    public static List<JetFile> getJetFiles(final @NotNull Project project, @NotNull Collection<String> sourceRoots, @NotNull Function1<String, Unit> reportError) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getJetFiles"));
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getJetFiles"));
        }
        if (reportError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportError", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getJetFiles"));
        }
        final VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        final HashSet processedFiles = Sets.newHashSet();
        final ArrayList<JetFile> result2 = Lists.newArrayList();
        for (String sourceRootPath : sourceRoots) {
            if (sourceRootPath == null) continue;
            VirtualFile vFile = localFileSystem.findFileByPath(sourceRootPath);
            if (vFile == null) {
                reportError.invoke("Source file or directory not found: " + sourceRootPath);
                continue;
            }
            if (!vFile.isDirectory() && vFile.getFileType() != JetFileType.INSTANCE) {
                reportError.invoke("Source entry is not a Kotlin file: " + sourceRootPath);
                continue;
            }
            IoPackage.recurse(new File(sourceRootPath), (Function1<? super File, ? extends Unit>)new Function1<File, Unit>(){

                @Override
                public Unit invoke(File file) {
                    VirtualFile virtualFile;
                    if (file.isFile() && (virtualFile = localFileSystem.findFileByPath(file.getAbsolutePath())) != null && !processedFiles.contains(virtualFile)) {
                        processedFiles.add(virtualFile);
                        PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
                        if (psiFile instanceof JetFile) {
                            result2.add((JetFile)psiFile);
                        }
                    }
                    return Unit.INSTANCE$;
                }
            });
        }
        ArrayList<JetFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "getJetFiles"));
        }
        return arrayList;
    }
}

