/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.java.stubs.JavaParameterElementType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ParameterElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.ParameterElement");

    public ParameterElement(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/java/ParameterElement", "<init>"));
        }
        super(type2);
    }

    @Override
    public int getTextOffset() {
        ASTNode node2 = this.findChildByType(JavaParameterElementType.ID_TYPES);
        return node2 != null ? node2.getStartOffset() : this.getStartOffset();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        if (role == 8) {
            return this.findChildByType(JavaElementType.MODIFIER_LIST);
        }
        if (role == 9) {
            return this.findChildByType(JavaTokenType.IDENTIFIER);
        }
        if (role == 10) {
            return this.findChildByType(JavaElementType.TYPE);
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        if (i == JavaElementType.TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        return 0;
    }
}

