/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl");
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement parent, String text) {
        super(parent, JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned(text);
        this.myText = interned == null ? text : ((Object)interned).toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation2 = SoftReference.dereference(this.myParsedFromRepository);
        if (annotation2 != null) {
            return annotation2;
        }
        String text = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            annotation2 = facade.createAnnotationFromText(text, (PsiElement)this.getPsi());
            this.myParsedFromRepository = new SoftReference<PsiAnnotation>(annotation2);
            return annotation2;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in repository!", e);
            return null;
        }
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + "]";
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(AnnotationUtil.class);
        CharTableImpl.staticIntern("@NotNull");
        CharTableImpl.staticIntern("@Nullable");
        CharTableImpl.staticIntern("@Override");
    }
}

