/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiClassType
extends PsiType {
    public static final PsiClassType[] EMPTY_ARRAY = new PsiClassType[0];
    public static final ArrayFactory<PsiClassType> ARRAY_FACTORY = new ArrayFactory<PsiClassType>(){

        @NotNull
        public PsiClassType[] create(int count) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[count];
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiClassType$1", "create"));
            }
            return psiClassTypeArray;
        }
    };
    protected final LanguageLevel myLanguageLevel;

    protected PsiClassType(LanguageLevel languageLevel) {
        this(languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    protected PsiClassType(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiClassType", "<init>"));
        }
        super(annotations2);
        this.myLanguageLevel = languageLevel;
    }

    @Nullable
    public abstract PsiClass resolve();

    public abstract String getClassName();

    @NotNull
    public abstract PsiType[] getParameters();

    public int getParameterCount() {
        return this.getParameters().length;
    }

    public boolean equals(Object obj) {
        ClassResolveResult otherResult;
        String otherClassName;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiClassType)) {
            return false;
        }
        PsiClassType otherClassType = (PsiClassType)obj;
        String className = this.getClassName();
        if (!Comparing.equal(className, otherClassName = otherClassType.getClassName())) {
            return false;
        }
        if (this.getParameterCount() != otherClassType.getParameterCount()) {
            return false;
        }
        ClassResolveResult result2 = this.resolveGenerics();
        if (result2 == (otherResult = otherClassType.resolveGenerics())) {
            return true;
        }
        PsiClass aClass = result2.getElement();
        PsiClass otherClass = otherResult.getElement();
        if (aClass == null || otherClass == null) {
            return aClass == otherClass;
        }
        return aClass.getManager().areElementsEquivalent(aClass, otherClass) && (PsiUtil.isRawSubstitutor(aClass, result2.getSubstitutor()) || PsiUtil.equalOnEquivalentClasses(result2.getSubstitutor(), aClass, otherResult.getSubstitutor(), otherClass));
    }

    public boolean hasParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        boolean hasParams = false;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            if (resolveResult.getSubstitutor().substitute(parameter) == null) {
                return false;
            }
            hasParams = true;
        }
        return hasParams;
    }

    public boolean hasNonTrivialParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiClass superClass;
            PsiType type2 = resolveResult.getSubstitutor().substitute(parameter);
            if (type2 == null) continue;
            if (!(type2 instanceof PsiWildcardType)) {
                return true;
            }
            PsiType bound = ((PsiWildcardType)type2).getBound();
            if (bound == null || ((PsiWildcardType)type2).isExtends() && (superClass = parameter.getSuperClass()) != null && PsiUtil.resolveClassInType(bound) == superClass) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        String className = this.getClassName();
        if (className == null) {
            return 0;
        }
        return className.hashCode();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiClassType", "getSuperTypes"));
            }
            return EMPTY_ARRAY;
        }
        PsiClassType[] superTypes = aClass.getSuperTypes();
        PsiType[] substitutionResults = PsiClassType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            substitutionResults[i] = resolveResult.getSubstitutor().substitute(superTypes[i]);
        }
        if (substitutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiClassType", "getSuperTypes"));
        }
        return substitutionResults;
    }

    public static boolean isRaw(ClassResolveResult resolveResult) {
        PsiClass psiClass = resolveResult.getElement();
        return psiClass != null && PsiUtil.isRawSubstitutor(psiClass, resolveResult.getSubstitutor());
    }

    public boolean isRaw() {
        return PsiClassType.isRaw(this.resolveGenerics());
    }

    @NotNull
    public abstract ClassResolveResult resolveGenerics();

    @NotNull
    public abstract PsiClassType rawType();

    @Override
    @NotNull
    public abstract GlobalSearchScope getResolveScope();

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiClassType", "accept"));
        }
        return visitor2.visitClassType(this);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    @NotNull
    @Contract(pure=true)
    public abstract PsiClassType setLanguageLevel(@NotNull LanguageLevel var1);

    public static abstract class Stub
    extends PsiClassType {
        protected Stub(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
            if (annotations2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiClassType$Stub", "<init>"));
            }
            super(languageLevel, annotations2);
        }

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiClassType$Stub", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);
    }

    public static interface ClassResolveResult
    extends JavaResolveResult {
        public static final ClassResolveResult EMPTY = new ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return null;
            }

            @Override
            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiClassType$ClassResolveResult$1", "getSubstitutor"));
                }
                return psiSubstitutor;
            }

            @Override
            public boolean isValidResult() {
                return false;
            }

            @Override
            public boolean isAccessible() {
                return false;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return false;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };

        @Override
        public PsiClass getElement();
    }
}

