/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NotNullLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private final NotNullFunction<H, T> myFunction;

    private NotNullLazyKey(@NotNull @NonNls String name, @NotNull NotNullFunction<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/NotNullLazyKey", "<init>"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/openapi/util/NotNullLazyKey", "<init>"));
        }
        super(name);
        this.myFunction = function;
    }

    @NotNull
    public final T getValue(@NotNull H h) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "com/intellij/openapi/util/NotNullLazyKey", "getValue"));
        }
        Object data2 = h.getUserData(this);
        if (data2 == null) {
            data2 = this.myFunction.fun(h);
            h.putUserData(this, data2);
        }
        Object t = data2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyKey", "getValue"));
        }
        return t;
    }

    public static <T, H extends UserDataHolder> NotNullLazyKey<T, H> create(@NonNls @NotNull String name, @NotNull NotNullFunction<H, T> function) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/NotNullLazyKey", "create"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/openapi/util/NotNullLazyKey", "create"));
        }
        return new NotNullLazyKey<T, H>(name, function);
    }
}

