/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class CommonSupertypes {
    @Nullable
    public static JetType commonSupertypeForNonDenotableTypes(@NotNull Collection<JetType> types) {
        JetType type2;
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertypeForNonDenotableTypes"));
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1 && (type2 = types.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @NotNull
    public static JetType commonSupertype(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
        }
        JetType jetType = CommonSupertypes.findCommonSupertype(types, 0, CommonSupertypes.maxDepth(types) + 3);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
        }
        return jetType;
    }

    private static int maxDepth(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "maxDepth"));
        }
        int max = 0;
        for (JetType type2 : types) {
            int depth = CommonSupertypes.depth(type2);
            if (max >= depth) continue;
            max = depth;
        }
        return max;
    }

    private static int depth(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CommonSupertypes", "depth"));
        }
        return 1 + CommonSupertypes.maxDepth(KotlinPackage.map(type2.getArguments(), new Function1<TypeProjection, JetType>(){

            @Override
            public JetType invoke(TypeProjection projection) {
                return projection.getType();
            }
        }));
    }

    @NotNull
    private static JetType findCommonSupertype(@NotNull Collection<JetType> types, int recursionDepth, int maxDepth) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
        }
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types;
        boolean hasFlexible = false;
        ArrayList<JetType> upper = new ArrayList<JetType>(types.size());
        ArrayList<JetType> lower = new ArrayList<JetType>(types.size());
        LinkedHashSet<FlexibleTypeCapabilities> capabilities = new LinkedHashSet<FlexibleTypeCapabilities>();
        for (JetType type2 : types) {
            if (TypesPackage.isFlexible(type2)) {
                hasFlexible = true;
                Flexibility flexibility = TypesPackage.flexibility(type2);
                upper.add(flexibility.getUpperBound());
                lower.add(flexibility.getLowerBound());
                capabilities.add(flexibility.getExtraCapabilities());
                continue;
            }
            upper.add(type2);
            lower.add(type2);
        }
        if (!hasFlexible) {
            JetType jetType = CommonSupertypes.commonSuperTypeForInflexible(types, recursionDepth, maxDepth);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
            }
            return jetType;
        }
        JetType jetType = DelegatingFlexibleType.create(CommonSupertypes.commonSuperTypeForInflexible(lower, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth), (FlexibleTypeCapabilities)KotlinPackage.single(capabilities));
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
        }
        return jetType;
    }

    @NotNull
    private static JetType commonSuperTypeForInflexible(@NotNull Collection<JetType> types, int recursionDepth, int maxDepth) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        assert (!types.isEmpty());
        HashSet<JetType> typeSet = new HashSet<JetType>(types);
        JetType bestFit = TypesPackage.singleBestRepresentative(typeSet);
        if (bestFit != null) {
            JetType jetType = bestFit;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return jetType;
        }
        boolean nullable2 = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            JetType type2 = (JetType)iterator2.next();
            assert (type2 != null);
            assert (!TypesPackage.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (type2.isError()) {
                JetType jetType = ErrorUtils.createErrorType("Supertype of error type " + type2);
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
                }
                return jetType;
            }
            nullable2 |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            JetType jetType = nullable2 ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return jetType;
        }
        if (typeSet.size() == 1) {
            JetType jetType = TypeUtils.makeNullableIfNeeded((JetType)typeSet.iterator().next(), nullable2);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return jetType;
        }
        Map<TypeConstructor, Set<JetType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<JetType> merge = new HashSet<JetType>();
            for (Set<JetType> supertypes2 : commonSupertypes.values()) {
                merge.addAll(supertypes2);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types;
        Map.Entry<TypeConstructor, Set<JetType>> entry = commonSupertypes.entrySet().iterator().next();
        JetType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        JetType jetType = TypeUtils.makeNullableIfNeeded(result2, nullable2);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        return jetType;
    }

    @NotNull
    private static Map<TypeConstructor, Set<JetType>> computeCommonRawSupertypes(@NotNull Collection<JetType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        assert (!types.isEmpty());
        HashMap<TypeConstructor, Set<JetType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<JetType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (JetType type2 : types) {
            HashSet<TypeConstructor> visited = new HashSet<TypeConstructor>();
            order = TypeUtils.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited;
                continue;
            }
            commonSuperclasses.retainAll(visited);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<JetType>> result2 = new HashMap<TypeConstructor, Set<JetType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<JetType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        HashMap<TypeConstructor, Set<JetType>> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        return hashMap;
    }

    @NotNull
    private static JetType computeSupertypeProjections(@NotNull TypeConstructor constructor2, @NotNull Set<JetType> types, int recursionDepth, int maxDepth) {
        if (constructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        assert (!types.isEmpty());
        if (types.size() == 1) {
            JetType jetType = types.iterator().next();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
            }
            return jetType;
        }
        List<TypeParameterDescriptor> parameters2 = constructor2.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>();
        int parametersSize = parameters2.size();
        for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters2.get(i);
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (JetType type2 : types) {
                typeProjections.add(type2.getArguments().get(i));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections, recursionDepth, maxDepth));
        }
        boolean nullable2 = false;
        for (JetType type3 : types) {
            nullable2 |= type3.isMarkedNullable();
        }
        JetScope newScope = JetScope.Empty.INSTANCE$;
        ClassifierDescriptor declarationDescriptor = constructor2.getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            newScope = ((ClassDescriptor)declarationDescriptor).getMemberScope(newProjections);
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, constructor2, nullable2, newProjections, newScope);
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        Variance projectionKind;
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        TypeProjection singleBestProjection = TypesPackage.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            TypeProjection typeProjection = singleBestProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        if (recursionDepth >= maxDepth) {
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, KotlinBuiltIns.getInstance().getNullableAnyType());
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        HashSet<JetType> ins = new HashSet<JetType>();
        HashSet<JetType> outs = new HashSet<JetType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind2 = projection.getProjectionKind();
            if (projectionKind2.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind2.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth));
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        if (ins != null) {
            JetType intersection = TypeUtils.intersect(JetTypeChecker.DEFAULT, ins);
            if (intersection == null) {
                TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(Variance.OUT_VARIANCE, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
                if (typeProjectionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return typeProjectionImpl;
            }
            Variance projectionKind3 = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind3, intersection);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, CommonSupertypes.findCommonSupertype(parameterDescriptor.getUpperBounds(), recursionDepth + 1, maxDepth));
        if (typeProjectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        return typeProjectionImpl;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/types/CommonSupertypes", "markAll"));
        }
        if (markerSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerSet", "org/jetbrains/kotlin/types/CommonSupertypes", "markAll"));
        }
        markerSet.add(typeConstructor2);
        for (JetType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }
}

