/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.Interner;
import org.jetbrains.kotlin.serialization.ProtoBuf;

public class StringTable {
    public static final TObjectHashingStrategy<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> QUALIFIED_NAME_BUILDER_HASHING = new TObjectHashingStrategy<ProtoBuf.QualifiedNameTable.QualifiedName.Builder>(){

        @Override
        public int computeHashCode(ProtoBuf.QualifiedNameTable.QualifiedName.Builder object2) {
            int result2 = 13;
            result2 = 31 * result2 + object2.getParentQualifiedName();
            result2 = 31 * result2 + object2.getShortName();
            result2 = 31 * result2 + object2.getKind().hashCode();
            return result2;
        }

        @Override
        public boolean equals(ProtoBuf.QualifiedNameTable.QualifiedName.Builder o1, ProtoBuf.QualifiedNameTable.QualifiedName.Builder o2) {
            return o1.getParentQualifiedName() == o2.getParentQualifiedName() && o1.getShortName() == o2.getShortName() && o1.getKind() == o2.getKind();
        }
    };
    private final Interner<String> strings = new Interner();
    private final Interner<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> qualifiedNames = new Interner<ProtoBuf.QualifiedNameTable.QualifiedName.Builder>(QUALIFIED_NAME_BUILDER_HASHING);

    @NotNull
    public List<String> getStrings() {
        List<String> list = this.strings.getAllInternedObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/StringTable", "getStrings"));
        }
        return list;
    }

    @NotNull
    public List<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> getFqNames() {
        List<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> list = this.qualifiedNames.getAllInternedObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/StringTable", "getFqNames"));
        }
        return list;
    }

    public int getSimpleNameIndex(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/serialization/StringTable", "getSimpleNameIndex"));
        }
        return this.getStringIndex(name.asString());
    }

    public int getStringIndex(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/serialization/StringTable", "getStringIndex"));
        }
        return this.strings.intern(string);
    }

    public int getFqNameIndex(@NotNull ClassOrPackageFragmentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/StringTable", "getFqNameIndex"));
        }
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        if (descriptor instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        }
        builder.setShortName(this.getSimpleNameIndex(descriptor.getName()));
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)containingDeclaration;
            if (!fragment.getFqName().isRoot()) {
                builder.setParentQualifiedName(this.getFqNameIndex(fragment.getFqName()));
            }
        } else if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor outerClass = (ClassDescriptor)containingDeclaration;
            builder.setParentQualifiedName(this.getFqNameIndex(outerClass));
        } else {
            throw new IllegalStateException("FQ names are only stored for top-level or inner classes: " + descriptor);
        }
        return this.qualifiedNames.intern(builder);
    }

    public int getFqNameIndex(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/serialization/StringTable", "getFqNameIndex"));
        }
        int result2 = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            builder.setShortName(this.getSimpleNameIndex(segment));
            if (result2 != -1) {
                builder.setParentQualifiedName(result2);
            }
            result2 = this.qualifiedNames.intern(builder);
        }
        return result2;
    }
}

