/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.NameSerializationUtil;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.utils.UtilsPackage;

public final class ClassData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Class classProto;

    @NotNull
    public static ClassData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        ClassData classData;
        block4: {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/kotlin/serialization/ClassData", "read"));
            }
            if (registry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "org/jetbrains/kotlin/serialization/ClassData", "read"));
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                NameResolver nameResolver = NameSerializationUtil.deserializeNameResolver(in);
                ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(in, registry);
                classData = new ClassData(nameResolver, classProto);
                if (classData != null) break block4;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/ClassData", "read"));
        }
        return classData;
    }

    public ClassData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/kotlin/serialization/ClassData", "<init>"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/kotlin/serialization/ClassData", "<init>"));
        }
        this.nameResolver = nameResolver;
        this.classProto = classProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        NameResolver nameResolver = this.nameResolver;
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/ClassData", "getNameResolver"));
        }
        return nameResolver;
    }

    @NotNull
    public ProtoBuf.Class getClassProto() {
        ProtoBuf.Class clazz = this.classProto;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/ClassData", "getClassProto"));
        }
        return clazz;
    }

    @NotNull
    public byte[] toBytes() {
        byte[] byArray;
        try {
            ByteArrayOutputStream result2 = new ByteArrayOutputStream();
            NameSerializationUtil.serializeNameResolver(result2, this.nameResolver);
            this.classProto.writeTo(result2);
            byArray = result2.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/ClassData", "toBytes"));
        }
        return byArray;
    }
}

